<?php

define('SECURE_ACCESS', true);

$config = require '/home1/footbal1/secure_config/config.php';
require_once __DIR__ . '/functions.php';

try {
    $db = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", $config['db_user'], $config['db_pass']);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// گرفتن بازی‌هایی که هنوز result ندارند
$stmt = $db->prepare("SELECT id, match_day FROM matches WHERE result IS NULL OR result = ''");
$stmt->execute();
$matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$matches) {
    logMessage("INFO", "✅ هیچ بازی بدون نتیجه‌ای پیدا نشد.");
    exit;
}

// گروه‌بندی بازی‌ها بر اساس تاریخ match_day
$byDate = [];
foreach ($matches as $m) {
    $date = str_replace('-', '', $m['match_day']); // YYYYMMDD
    $byDate[$date][] = $m['id'];
}

// پردازش هر تاریخ
foreach ($byDate as $ymd => $match_ids) {
    logMessage("INFO", "📅 بررسی تاریخ $ymd برای " . count($match_ids) . " بازی.");

    $url = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$ymd/3.30?countryCode=FR&locale=en&MD=1";
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => "User-Agent: Mozilla/5.0\r\n"
        ]
    ]);

    $response = @file_get_contents($url, false, $context);
    if (!$response) {
        logMessage("ERROR", "⚠️ دریافت اطلاعات از API برای $ymd با خطا مواجه شد.");
        continue;
    }

    $data = json_decode($response);
    if (!$data || !isset($data->Stages)) {
        logMessage("ERROR", "⚠️ ساختار API برای $ymd نامعتبر بود.");
        continue;
    }

    foreach ($data->Stages as $stage) {
        if (!isset($stage->Events)) continue;

        $events = is_object($stage->Events) ? get_object_vars($stage->Events) : $stage->Events;

        foreach ($events as $event) {
            if (!isset($event->Eid)) continue;
            $eid = $event->Eid;

            if (!in_array($eid, $match_ids)) continue;

            $gameStatus = $event->Eps ?? null;
            
            // اگر بازی به پنالتی رسیده (AP) از Trp1 و Trp2 استفاده کن
            if ($gameStatus === 'AP' && isset($event->Trp1) && isset($event->Trp2)) {
                $homeScore = $event->Trp1;
                $awayScore = $event->Trp2;
            } else {
                // در غیر این صورت از نتیجه عادی استفاده کن
                $homeScore = $event->Tr1 ?? null;
                $awayScore = $event->Tr2 ?? null;
            }
            
            logMessage("DEBUG", "🎯 بازی $eid | Tr1: $homeScore - Tr2: $awayScore | وضعیت: $gameStatus");

            // فقط وقتی بازی کامل شده باشه و گل‌ها مشخص باشن
            if (!in_array($gameStatus, ['FT','AP','AET']) || $homeScore === null || $awayScore === null) {
                logMessage("INFO", "⏭ بازی $eid هنوز کامل نشده یا گل‌ها مشخص نیستن.");
                continue;
            }

            // تعیین نتیجه
            if ($homeScore > $awayScore) {
                $result = 'home';
            } elseif ($homeScore < $awayScore) {
                $result = 'away';
            } else {
                $result = 'draw';
            }
            
            // ذخیره نتیجه در جدول matches
            $stmt = $db->prepare("UPDATE matches SET result = ? WHERE id = ?");
            $stmt->execute([$result, $eid]);
            
            // 🔥 بلافاصله بعد از ذخیره نتیجه، بررسی پیش‌بینی‌ها و آپدیت is_correct:
            $real_result = strtolower(trim($result));     // نتیجه واقعی استانداردسازی‌شده
            $match_id = $eid;                             // آیدی مسابقه
            
            $stmt = $db->prepare("SELECT id, prediction FROM predictions WHERE match_id = ?");
            $stmt->execute([$match_id]);
            $predictions = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($predictions as $prediction) {
                $user_prediction = strtolower(trim($prediction['prediction']));  // استانداردسازی مقدار prediction
            
                $is_correct = ($user_prediction === $real_result) ? 1 : 0;
            
                $update = $db->prepare("UPDATE predictions SET is_correct = ? WHERE id = ?");
                $update->execute([$is_correct, $prediction['id']]);
            }

            logMessage("SQL", "UPDATE matches SET result = '$result' WHERE id = $eid;");
            logMessage("INFO", "✅ نتیجه '$result' برای بازی $eid ثبت شد.");
        }
    }
}

logMessage("INFO", "🎯 بررسی همه بازی‌ها به پایان رسید.");
echo "🔚 پایان اجرا\n";
