<?php
date_default_timezone_set("Asia/Tehran");

define('SECURE_ACCESS', true);

require __DIR__ . '/functions.php';
$config = require '/home1/footbal1/secure_config/config.php';

$token = $config['token'];
$today = date("Y-m-d");

// اتصال به دیتابیس
try {
    $db = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", $config['db_user'], $config['db_pass']);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// لیست لیگ‌های مجاز برای ارسال
$My_Ligs = [
    20030, 20594, 20160, 21886, 20125];
    
$placeholders = implode(',', array_fill(0, count($My_Ligs), '?'));

// دریافت بازی‌های امروز که نتیجه دارند و در لیست لیگ‌های مجاز هستند
$sql = "SELECT * FROM matches 
        WHERE match_day = ? AND result IS NOT NULL AND result != '' 
        AND league_id IN ($placeholders)";
$stmt = $db->prepare($sql);
$stmt->execute(array_merge([$today], $My_Ligs));

$matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$matches) {
logMessage("WARNING", "⚠️ No results found for today.");
    exit;
}

$message = "🏆 نتایج نهایی بازی‌های امروز:\n\n";
foreach ($matches as $match) {
    $home = $match['team_home'];
    $away = $match['team_away'];
    $home = getTeamName($home);
    $away = getTeamName($away);
    $dt = new DateTime($match['match_time'], new DateTimeZone('UTC'));
    $dt->setTimezone(new DateTimeZone('Asia/Tehran'));
    $time = $dt->format("H:i");

    $line = "▫️ $home VS ▫️ $away ➡️ ";

    if ($match['result'] === 'home') {
        $line .= "برد $home";
    } elseif ($match['result'] === 'away') {
        $line .= "برد $away";
    } elseif ($match['result'] === 'draw') {
        $line .= "مساوی";
    }

    $message .= "$line\n";
}

// ارسال به کانال
sendTelegramMessage('@KickPrediict', $message, $token);

// تابع ارسال
function sendTelegramMessage($chat_id, $text, $token) {
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $data = ['chat_id' => $chat_id, 'text' => $text];
    $options = ['http' => ['method' => 'POST', 'header'  => "Content-type: application/x-www-form-urlencoded", 'content' => http_build_query($data)]];
    $context = stream_context_create($options);
    $response = file_get_contents($url, false, $context);
logMessage("INFO", "📨 RESPONSE:\n" . $response);
}
