<?php
date_default_timezone_set("Asia/Tehran");
ini_set('display_errors', 1);
error_reporting(E_ALL);

define('SECURE_ACCESS', true);

$config = require '/home1/footbal1/secure_config/config.php';
require_once __DIR__ . '/functions.php';

$website = "https://api.telegram.org/bot" . $config['token'];

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
        $config['db_user'],
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

$stmt = $db->prepare("
    SELECT p.user_id, p.match_id, m.team_home, m.team_away, m.match_time, p.prediction
    FROM predictions p
    JOIN matches m ON p.match_id = m.id
    JOIN users u ON p.user_id = u.user_id
    WHERE 
        u.notify_enabled = 1
        AND m.result IS NULL
        AND TIMESTAMPDIFF(MINUTE, NOW(), m.match_time) BETWEEN 0 AND 15
        AND NOT EXISTS (
            SELECT 1 FROM prediction_alerts a 
            WHERE a.user_id = p.user_id AND a.match_id = p.match_id AND a.type = 'reminder'
        )
    ORDER BY m.match_time ASC
");
$stmt->execute();
$reminders_raw = $stmt->fetchAll(PDO::FETCH_ASSOC);

// فیلتر به‌صورت فقط یک بازی برای هر کاربر
$reminders = [];

foreach ($reminders as $r) {
    $chat_id = $r['user_id'];
    $prediction = $r['prediction'];
    $home = $r['team_home'];
    $away = $r['team_away'];

    if ($prediction) {
        $text = "⏰ بازی در آستانه شروعه!\n"
              . "🆚 $home vs $away\n"
              . "🎯 پیش‌بینی شما ثبت شده. آماده تماشای بازی باش!";
        $params = ['chat_id' => $chat_id, 'text' => $text];
    } else {
        $text = "⏰ بازی داره شروع میشه!\n"
              . "🆚 $home vs $away\n"
              . "✍️ هنوز پیش‌بینی نکردی. همین الان انجام بده:";
        $params = [
            'chat_id' => $chat_id,
            'text' => $text,
            'reply_markup' => json_encode([
                'inline_keyboard' => [
                    $keyboard[] = [['text' => '🧮 پیش بینی یادت نره!', 'callback_data' => 'start_prediction']]
                ]
            ])
        ];
    }

    // ارسال پیام
    file_get_contents($website . "/sendMessage?" . http_build_query($params));

    // ذخیره در جدول که پیام فرستاده شده
    $insert = $db->prepare("INSERT INTO prediction_alerts (user_id, match_id, type) VALUES (?, ?, 'reminder')");
    $insert->execute([$chat_id, $r['match_id']]);
}
