<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set("Asia/Tehran");

define('SECURE_ACCESS', true);

$config = require '/home1/footbal1/secure_config/config.php';
require_once __DIR__ . '/functions.php';

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", 
        $config['db_user'], 
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// فقط یک پیش‌بینی که نتیجه اومده ولی هنوز پاداش و پیامش ثبت نشده
$stmt = $db->prepare("
    SELECT p.user_id, p.match_id, p.prediction, m.result, m.team_home, m.team_away
    FROM predictions p
    JOIN matches m ON p.match_id = m.id
    WHERE m.result IS NOT NULL AND m.result != ''
      AND NOT EXISTS (
          SELECT 1 FROM prediction_rewards r 
          WHERE r.user_id = p.user_id AND r.match_id = p.match_id
      )
    ORDER BY m.match_time DESC
    LIMIT 1
");
$stmt->execute();
$prediction = $stmt->fetch(PDO::FETCH_ASSOC);

if ($prediction) {
    $user_id = $prediction['user_id'];
    $match_id = $prediction['match_id'];
    $user_prediction = $prediction['prediction'];
    $actual_result = $prediction['result'];
    $home = getTeamName ($prediction['team_home']);
    $away = getTeamName ($prediction['team_away']);

    $status = ($user_prediction === $actual_result) ? "✅ درست" : "❌ اشتباه";

    // قبل از ارسال پیام، ثبت پاداش (جلوگیری از تکرار)
    $insert = $db->prepare("INSERT INTO prediction_rewards (user_id, match_id) VALUES (?, ?)");
    $insert->execute([$user_id, $match_id]);

    // اگر درست بود، امتیاز بده
    if ($status === "✅ درست") {
        $db->prepare("UPDATE users SET score = score + 5 WHERE user_id = ?")->execute([$user_id]);
    }

    // آماده‌سازی پیام
    $text = "🔔 <b>نتیجه پیش‌بینی رایگان تو مشخص شد!</b>\n\n"
          . "☑️ $home vs $away\n"
          . "🔸 پیش‌بینی تو: " . matchText($user_prediction, $home, $away) . "\n"
          . "🔹 نتیجه واقعی: " . matchText($actual_result, $home, $away) . "\n"
          . "📊 وضعیت: $status";

    // ارسال پیام
    sendPlainMessage($user_id, $text);

    echo "✅ پیام ارسال شد برای کاربر $user_id | بازی $match_id\n";
} else {
    echo "⏳ بازی یا پیش‌بینی جدیدی برای ارسال وجود ندارد.\n";
}
