<?php
date_default_timezone_set("Asia/Tehran");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

define('SECURE_ACCESS', true);

$config = require '/home1/footbal1/secure_config/config.php';

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8",
        $config['db_user'],
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("خطا در اتصال به دیتابیس: " . $e->getMessage());
}

$stmt = $db->query("SELECT team_id FROM featured_teams WHERE is_active = 1");
$featuredTeams = array_map('intval', $stmt->fetchAll(PDO::FETCH_COLUMN));

$url = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/" . date("Ymd") . "/3.30?countryCode=FR&locale=en&MD=1";
$response = file_get_contents($url);
$data = json_decode($response);

if (!isset($data->Stages)) {
    echo "❌ Stage خالی بود!\n";
    exit;
}

foreach ($data->Stages as $stage) {
    $leagueId = $stage->Sid ?? null;
    $leagueName = $stage->CompN ?? ($stage->Cnm ?? 'نامشخص');

    if (!$leagueId) { continue; } // فیلتر لیگ حذف شد


    $stmt = $db->prepare("INSERT IGNORE INTO leagues (id, name) VALUES (?, ?)");
    $stmt->execute([$leagueId, $leagueName]);

    $events = is_object($stage->Events) ? get_object_vars($stage->Events) : $stage->Events;

    foreach ($events as $event) {
        if (!isset($event->Eid) || !isset($event->T1[0]->Nm) || !isset($event->T2[0]->Nm) || !isset($event->Esd)) {
            continue;
        }
        $homeId = (int)($event->T1[0]->ID ?? 0);
        $awayId = (int)($event->T2[0]->ID ?? 0);
        if (!in_array($homeId, $featuredTeams, true) && !in_array($awayId, $featuredTeams, true)) {
            continue; // هیچ‌کدام جزو تیم‌های ویژه نیستند
        }


        $eid = $event->Eid;
        $home = $event->T1[0]->Nm;
        $away = $event->T2[0]->Nm;

        // $utc = new DateTimeZone("UTC");
        $tehran = new DateTimeZone("Asia/Tehran");

        $dt = DateTime::createFromFormat("YmdHi", substr($event->Esd, 0, 12), $tehran);
        if ($dt !== false) {
            $dt->setTimezone($tehran);
            $match_time = $dt->format("Y-m-d H:i:s");
            $match_day = $dt->format("Y-m-d");

            $stmt = $db->prepare("INSERT INTO matches (id, league_id, team_home, team_away, match_time, match_day)
                                  VALUES (?, ?, ?, ?, ?, ?)
                                  ON DUPLICATE KEY UPDATE 
                                      match_time = VALUES(match_time),
                                      match_day = VALUES(match_day),
                                      team_home = VALUES(team_home),
                                      team_away = VALUES(team_away)");
            $stmt->execute([$eid, $leagueId, $home, $away, $match_time, $match_day]);

            echo "✅ ذخیره شد: $eid - $home vs $away\n";
        } else {
            echo "⚠️ تاریخ نامعتبر: {$event->Esd}\n";
        }
    }
}

echo "\n🎯 تمام بازی‌های امروز ذخیره شدند.\n";
