<?php
ini_set('display_errors',1);
error_reporting(E_ALL);

$ymd = '20250704';
$matchId = '1418976';

$url = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/$ymd/3.30?countryCode=FR&locale=en&MD=1";
$response = @file_get_contents($url);
if (!$response) {
    echo "❌ Failed to fetch API data.";
    exit;
}

$data = json_decode($response);
if (!isset($data->Stages)) {
    echo "❌ Invalid API structure.";
    exit;
}

foreach ($data->Stages as $stage) {
    if (!isset($stage->Events)) continue;

    $events = is_object($stage->Events) ? get_object_vars($stage->Events) : $stage->Events;
    foreach ($events as $event) {
        if (!isset($event->Eid)) continue;

        if ($event->Eid == $matchId) {
            echo "✅ FOUND: \n";
            echo "Eps: " . ($event->Eps ?? '???') . "\n";
            echo "Tr1: " . ($event->Tr1 ?? '???') . "\n";
            echo "Tr2: " . ($event->Tr2 ?? '???') . "\n";
            echo "Team1: " . ($event->T1[0]->Nm ?? '???') . "\n";
            echo "Team2: " . ($event->T2[0]->Nm ?? '???') . "\n";
            exit;
        }
    }
}
echo "❌ Match ID $matchId NOT FOUND in $ymd.\n";
