<?php

$secret = 'MySecretToken_2025_X7P9';

if (($_SERVER['HTTP_X_TELEGRAM_BOT_API_SECRET_TOKEN'] ?? '') !== $secret) {
    http_response_code(401);
    exit('Invalid source');
}

define('SECURE_ACCESS', true);

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

$config = require '/home1/footbal1/secure_config/config.php';

// اتصال دیتابیس
try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", 
        $config['db_user'], 
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db_connected = true;
} catch (PDOException $e) {
    $db_connected = false;
}

$raw = file_get_contents("php://input");
$update = json_decode($raw, true);

$chat_id = null;
if (is_array($update)) {
    $chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"] ?? null;
}

// ست کردن منطقه زمانی
date_default_timezone_set("Asia/Tehran");

// بارگذاری تنظیمات و فایل‌های کمکی
require_once 'functions.php';
require_once 'handlers/menu.php';
require_once 'handlers/predictions.php';
require_once 'handlers/user.php';
require_once 'texts.php';
global $texts;

// تنظیمات توکن و آدرس ربات
$token = $config['token'];
$website = "https://api.telegram.org/bot$token/";

// استخراج اطلاعات از آپدیت
$chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"] ?? null;
$text = $update["message"]["text"] ?? null;
$callback_data = $update["callback_query"]["data"] ?? null;
$callback_id = $update["callback_query"]["id"] ?? null;

function getUserScore($chat_id) {
    global $db;
    $stmt = $db->prepare("SELECT score FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    return (int) $stmt->fetchColumn();
}

function ensureUserExists($user_id, $first_name = '', $username = '') {
    global $db;
    $stmt = $db->prepare("SELECT COUNT(*) FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    if ($stmt->fetchColumn() == 0) {
        $stmt = $db->prepare("INSERT INTO users (user_id, first_name, username, score) VALUES (?, ?, ?, 0)");
        $stmt->execute([$user_id, $first_name, $username]);
    }
    
}

// // $chat_id = $update["message"]["chat"]["id"] ?? $update["callback_query"]["message"]["chat"]["id"] ?? null;
// // $text = $update["message"]["text"] ?? null;
// // $callback_data = $update["callback_query"]["data"] ?? null;
// // $callback_id = $update["callback_query"]["id"] ?? null;

if (isset($update["message"]["contact"])) {
    $chat_id = $update["message"]["chat"]["id"];
    $message = $update["message"];
    $session = getUserSession($chat_id);

    if ($session && $session['mode'] === 'sell_mode') {
        $text = null;
        goto sell_mode;
    }

    // 🔄 اگر در حالت خاصی نیست، فقط شماره رو ذخیره کن و پیام موفقیت بده
    $contact = $message["contact"];
    $phone = str_replace(' ', '', $contact["phone_number"]);
    $sender_id = $message["from"]["id"];

    if ($contact["user_id"] != $sender_id) {
        sendMessage($chat_id, "⛔ فقط شماره‌ای که با همین حساب وارد تلگرام شدی مجازه.");
        return;
    }

    // فقط شماره‌های ایران، آلمان، اتریش
    if (!preg_match('/^\+?(98|49|43)\d{8,12}$/', $phone)) {
        sendMessage($chat_id, "⛔ فقط شماره‌های ایران 🇮🇷، آلمان 🇩🇪 یا اتریش 🇦🇹 مجاز هستند.");
        return;
    }

    if (strpos($phone, "+98") === 0) {
        $phone = "0" . substr($phone, 3);
    }

    // ذخیره در جدول users فقط اگر خالیه
    $stmt = $db->prepare("SELECT phone_number FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $existing = $stmt->fetchColumn();

    if (!$existing) {
        $stmt = $db->prepare("UPDATE users SET phone_number = ? WHERE user_id = ?");
        $stmt->execute([$phone, $chat_id]);
    }

    sendMessage($chat_id, "✅ شماره موبایل با موفقیت ثبت شد. حالا می‌تونی از امکانات ربات استفاده کنی.");
    showMainMenu($chat_id); // یا بفرست به صفحه اصلی

    return;
}

if ($callback_id) {
    answerCallbackQuery($callback_id, "");
}

if (isset($update["callback_query"])) {

    $user_id = $update["callback_query"]["from"]["id"];
    $first_name = $update["callback_query"]["from"]["first_name"] ?? '';
    $username = $update["callback_query"]["from"]["username"] ?? '';

    ensureUserExists($user_id, $first_name, $username);

    $callback_data = $update["callback_query"]["data"];
    $message_id = $update['callback_query']['message']['message_id'];
    $callback_id = $update["callback_query"]["id"];
    answerCallbackQuery($callback_id,"");
    // file_get_contents($website . "answerCallbackQuery?callback_query_id=" . $callback_id);

    switch (true) {
        
        case ($callback_data == "start"):
            showMainMenu($chat_id);
            break;

        case ($callback_data == "profile_menu"):
            $profile_buttons = getProfileButtons($chat_id);
            $userscore = showUserScore($chat_id);
            $first_name = $update["callback_query"]["from"]["first_name"] ?? '';
            $text = "👤 <b>سلام $first_name! به پروفایل شخصی خودت خوش اومدی 😊</b>\n\nاینجا می‌تونی امتیازها و سوابقت رو ببینی و پیش‌بینی‌هات رو حرفه‌ای‌تر مدیریت کنی.\n\n🎖 <b>توکن فعلی تو:</b> <b>{$userscore} توکن </b>";
            $text = convertEntofanumber($text);
            sendInlineKeyboard($chat_id, $text, $profile_buttons);            
            break;

        case ($callback_data == "main_menu"):
            showMainMenu($chat_id);
            break;

        case ($callback_data == "my_predictions"):
            showPredictionsMenu($chat_id);
            break;

        case ($callback_data == "active_predictions"):
            showActivePredictions($chat_id);
            break;

        case ($callback_data == "past_predictions"):
            showPastPredictions($chat_id);
            break;

        case ($callback_data == "prediction_history"):
            showPredictionHistory($chat_id);
            break;

        case ($callback_data == "predict_today"):
            showMatchesFromAPI($chat_id);
            break;
            
        case ($callback_data == "start_pool"):
            showPoolLeagues($chat_id);  
            break;
            
        case ($callback_data == "pool_invest"):
            showPoolIntro($chat_id, $message_id);
            break;
            
        case ($callback_data == "pool_rules"):
            showPoolRules($chat_id, $message_id);
            break;
            
        case ($callback_data == "pool_accept_rules"):
            confirmPoolRules($chat_id);
            break;
        
        case (strpos($callback_data, "pool_league_") === 0):
            $league_id = str_replace("pool_league_", "", $callback_data);
            showPoolMatchesByLeague_Pool($chat_id, $league_id);
            break;
            
        case (strpos($callback_data, "pool_match_") === 0):
            
                if (!rate_limit_check($chat_id, 'pool_match', 1, 5)) {
                sendMessage($chat_id, "⏳ لطفاً چند ثانیه بعد دوباره امتحان کن.");
                break;
            }

            $match_id = str_replace("pool_match_", "", $callback_data);
            showPoolPredictionOptions($chat_id, $match_id);
            break;
            
        case (strpos($callback_data, "pool_vote_") === 0):
            
                if (!rate_limit_check($chat_id, 'pool_vote', 1, 5)) {
                sendMessage($chat_id, "⏳ خیلی سریع سرمایه‌گذاری می‌کنی! لطفاً ۵ ثانیه صبر کن.");
                break;
            }

            $parts = explode("_", $callback_data);
            $match_id = $parts[2];
            $option = $parts[3];
        
            // ذخیره انتخاب کاربر در جدول pool_sessions
            $stmt = $db->prepare("
                INSERT INTO pool_sessions (user_id, match_id, option_selected)
                VALUES (?, ?, ?)
                ON DUPLICATE KEY UPDATE
                    match_id = VALUES(match_id),
                    option_selected = VALUES(option_selected),
                    created_at = NOW()
            ");
            $stmt->execute([$chat_id, $match_id, $option]);
        
            // ارسال پیام درخواست مقدار توکن
            $text = "✅ مقدار توکن سرمایه‌گذاری خود را وارد کن (مثلاً: ۲۵۰)\n\n"
                  . "💰 حداقل سرمایه‌گذاری: ۵۰ توکن\n"
                  . "💰 حداکثر سرمایه‌گذاری: ۱۵۰۰ توکن\n\n"
                  . "📌 لطفاً فقط یک عدد صحیح انگلیسی وارد کنید (بدون متن اضافی).";
        
            sendMessage($chat_id, $text);
        
            break;
            
        case (strpos($callback_data, "refresh_pool_") === 0):
            $match_id = str_replace("refresh_pool_", "", $callback_data);
            showPoolPredictionOptions($chat_id, $match_id);
            break;
            
        case ($callback_data == "my_investments"):
            showMyInvestments($chat_id);
            break;  

        case ($callback_data == "token_shop"):
            if (!isUserMember($chat_id)) {
                sendMessage($chat_id, $texts['membership_required'], null, 'Markdown');
                break;
            }
        
            $text = "💰 فروش کیوب‌کوین (مرحله آزمایشی)\n\n"
                  . "می‌تونی کیوب‌کوین‌هایی که با پیش‌بینی درست جمع کردی رو به ما بفروشی و پاداش بگیری.\n\n"
                  . "📌 بسته‌های فروش (شروع از ۷۵۰):\n"
                  . "• ۷۵۰ کیوب‌کوین = ۱۱۲,۵۰۰ تومان\n"
                  . "• ۱۵۰۰ کیوب‌کوین = ۲۲۵,۰۰۰ تومان\n"
                  . "• ۳۰۰۰ کیوب‌کوین = ۴۵۰,۰۰۰ تومان\n\n"
                  . "روش پرداخت: کارت‌به‌کارت\n"
                  . "اطلاعات بانکی و هویتی برای پرداخت الزامی است.\n\n"
                  . "🔥 هرچه بیشتر بفروشی، پاداشت بیشتره!";
        
            // اگر تبدیل اعداد به فارسی داری
            if (function_exists('convertEntofanumber')) {
                $text = convertEntofanumber($text);
            }
        
            $keyboard = [
                'inline_keyboard' => [
                    [ ['text' => '۷۵۰ کیوب‌کوین = ۱۱۲,۵۰۰ تومان',  'callback_data' => 'sell_750'] ],
                    [ ['text' => '۱۵۰۰ کیوب‌کوین = ۲۲۵,۰۰۰ تومان', 'callback_data' => 'sell_1500'] ],
                    [ ['text' => '۳۰۰۰ کیوب‌کوین = ۴۵۰,۰۰۰ تومان', 'callback_data' => 'sell_3000'] ],
                    [ ['text' => '💰 کیوب‌کوین‌های من',              'callback_data' => 'my_score'] ],
                    [ ['text' => '🔙 بازگشت',                         'callback_data' => 'main_menu'] ],
                ]
            ];
        
            sendMessage($chat_id, $text, $keyboard, 'Markdown');
            break;
        
        case (strpos($callback_data, 'sell_') === 0):
            $amount = (int) str_replace('sell_', '', $callback_data);
        
            // بررسی امتیاز کاربر
            $userScore = getUserScore($chat_id);
            if ($userScore < $amount) {
                sendMessage($chat_id, "⛔ شما فقط {$userScore} کیوب‌کوین داری و نمی‌تونی {$amount} تا بفروشی.");
                break;
            }
        
            // بررسی شماره تاییدشده
            $stmt = $db->prepare("SELECT phone_number FROM users WHERE user_id = ?");
            $stmt->execute([$chat_id]);
            $registered_phone = $stmt->fetchColumn();
        
            if (!$registered_phone) {
                // شماره تایید نشده → نمایش دکمه ارسال شماره
                setUserSession($chat_id, 'sell_mode', json_encode([
                    'step' => 'step_1',
                    'sell_amount' => $amount
                ]));
        
                $keyboard = [
                    "keyboard" => [
                        [["text" => "📱 ارسال شماره من", "request_contact" => true]]
                    ],
                    "resize_keyboard" => true,
                    "one_time_keyboard" => true
                ];
        
                sendMessage($chat_id, "📲 پرداخت ها فقط به شماره واقعی ثبت شده در تلگرامت تعلق میگیره. برای ادامه، لطفاً شماره موبایل خودت رو تأیید کن:", $keyboard);
                break;
            }
        
            // شماره ثبت شده → رفتن مستقیم به مرحله کارت
            setUserSession($chat_id, 'sell_mode', json_encode([
                'step' => 'step_2',
                'sell_amount' => $amount,
                'phone' => $registered_phone
            ]));
        
            sendMessage($chat_id, "💳 شماره کارت ۱۶ رقمی بانک خود را وارد کنید: \n\n ⚠️ پولات همیشه به همین شماره کارت واریز میشه و امکان تغییرش وجود نداره! ");
            break;
        
        case ($callback_data == "my_score"):
            $userscore = showUserScore($chat_id);
            $text = "💰 کیوب کوین های فعلی شما: $userscore توکن";
            $text = convertEntofanumber($text);
            sendMessage($chat_id, $text);
            break;
            
        case ($callback_data == "invite_friends"):
            $required_channels = ["@GoalTiime", "@KickPrediict"];
            $all_joined = true;
        
            // بررسی شماره موبایل ثبت‌شده
            $stmt = $db->prepare("SELECT phone_number FROM users WHERE user_id = ?");
            $stmt->execute([$chat_id]);
            $registered_phone = $stmt->fetchColumn();
        
            if (!$registered_phone) {
                $inline = [
                    'inline_keyboard' => [
                        [['text' => '📱 تأیید شماره موبایل', 'callback_data' => 'confirm_phone']]
                    ]
                ];
                sendMessage($chat_id, "⚠️ برای استفاده از سیستم دعوت دوستان، ابتدا باید شماره موبایلت رو تأیید کنی:", $inline);
                break;
            }
        
            // بررسی عضویت در کانال‌های مورد نیاز
            foreach ($required_channels as $channel) {
                $check = file_get_contents("https://api.telegram.org/bot".$config['token']."/getChatMember?chat_id={$channel}&user_id={$chat_id}");
                $data = json_decode($check, true);
        
                if (!isset($data['ok']) || $data['ok'] == false ||
                    in_array($data['result']['status'], ['left','kicked'])) {
                    $all_joined = false;
                    break;
                }
            }
        
            if (!$all_joined) {
                $msg = "📛 برای استفاده از قابلیت دعوت دوستان و دریافت پاداش، ابتدا باید در کانال‌های زیر عضو شوی:\n\n";
                foreach ($required_channels as $ch) {
                    $msg .= "🔗 {$ch}\n";
                }
                $msg .= "\nبعد از عضویت، دوباره دکمه «دعوت از دوستان» را بزن.";
                sendMessage($chat_id, $msg);
                break;
            }
        
            // ساخت لینک دعوت
            $invite_link = "https://t.me/KickPredict_bot?start=ref_" . $chat_id;
        
            $msg = "🎁 با دعوت از دوستانت ۱۵ توکن هدیه بگیر!\n\n"
                 . "🔗 لینک دعوت اختصاصی تو:\n"
                 . "<code>{$invite_link}</code>\n\n"
                 . "هر دوستی که با این لینک وارد ربات بشه، به تو ۱۵ توکن هدیه داده میشه.\n"
                 . "حداکثر ۱۰ دعوت موفق در هر هفته قابل ثبت هست.";
            sendMessage($chat_id, $msg, null, 'HTML');
            break;
            
        // 📦 نمایش فروشگاه توکن (خرید تا ۵۰۰، فروش از ۷۵۰)
        case ($callback_data == "open_token_shop"):
            $userscore = showUserScore($chat_id);
        
            $msg = "🎁 خوش آمدید به فروشگاه توکن!\n\n"
                 . "💰 کیوب‌کوین‌های فعلی شما: {$userscore} توکن\n\n"
                 . "🛒 بسته‌های خرید (حداکثر ۵۰۰ توکن):\n"
                 . "• بسته تازه‌کار — ۵۰ توکن = ۱۵,۰۰۰ ت\n"
                 . "• بسته نیم‌فصل — ۱۵۰ توکن = ۴۰,۰۰۰ ت\n"
                 . "• بسته ستاره‌ای — ۳۰۰ توکن = ۷۵,۰۰۰ ت\n"
                 . "• بسته قهرمان — ۵۰۰ توکن = ۱۲۰,۰۰۰ ت\n\n"
                 . "💬 برای خرید بیش از ۵۰۰ توکن با پشتیبانی در تماس باشید.\n\n";
            $msg = convertEntofanumber($msg);
        
            $keyboard = [
                'inline_keyboard' => [
                    [ ['text' => "🛒 بسته تازه‌کار (۵۰)",     'callback_data' => 'buy_token_pack_50'] ],
                    [ ['text' => "🛒 بسته نیم‌فصل (۱۵۰)",    'callback_data' => 'buy_token_pack_150'] ],
                    [ ['text' => "🛒 بسته ستاره‌ای (۳۰۰)",   'callback_data' => 'buy_token_pack_300'] ],
                    [ ['text' => "🛒 بسته قهرمان (۵۰۰)",     'callback_data' => 'buy_token_pack_500'] ],
                    // [ ['text' => "🎁 دریافت با دعوت دوستان", 'callback_data' => 'invite_friends'] ],
                    [ ['text' => "🔙 بازگشت",                'callback_data' => 'main_menu'] ],
                ]
            ];
        
            sendMessage($chat_id, $msg, $keyboard);
            break;
        
        // 💳 پردازش خرید بسته انتخاب‌شده (۵۰/۱۵۰/۳۰۰/۵۰۰)
        case ($callback_data == "buy_token_pack_50"):
        case ($callback_data == "buy_token_pack_150"):
        case ($callback_data == "buy_token_pack_300"):
        case ($callback_data == "buy_token_pack_500"):
        
            switch ($callback_data) {
                case "buy_token_pack_50":
                    $amount = "۱۵,۰۰۰ تومان";
                    $tokens_to_buy = 50;
                    break;
                case "buy_token_pack_150":
                    $amount = "۴۰,۰۰۰ تومان";
                    $tokens_to_buy = 150;
                    break;
                case "buy_token_pack_300":
                    $amount = "۷۵,۰۰۰ تومان";
                    $tokens_to_buy = 300;
                    break;
                case "buy_token_pack_500":
                    $amount = "۱۲۰,۰۰۰ تومان";
                    $tokens_to_buy = 500;
                    break;
            }
        
            $msg = "💳 لطفاً مبلغ {$amount} را به شماره کارت زیر واریز کن:\n\n"
                 . "🏦 شماره کارت: ۵۰۴۷۰۶۱۰۳۲۸۳۲۶۴۰\n\n"
                 . "سپس <b>۴ رقم آخر کارت</b> را فقط به <b>انگلیسی</b> و <b>بدون هیچ توضیحی</b> وارد کنید و منتظر تأیید پشتیبانی باشید.";
        
            setUserSession($chat_id, 'buy_mode', json_encode(['tokens_to_buy' => $tokens_to_buy]));
        
            $msg = convertEntofanumber($msg);
            sendMessage($chat_id, $msg);
            break;
    
        case ($callback_data == "support"):
            sendMessage($chat_id, "📩 لطفاً پیام خود را وارد کنید. پشتیبانی در اسرع وقت پاسخ خواهد داد.");
            setUserSession($chat_id, 'support_mode', json_encode(['status' => 'waiting']));
            break;

        case ($callback_data == "toggle_notify"):
            $stmt = $db->prepare("SELECT notify_enabled FROM users WHERE user_id = ?");
            $stmt->execute([$chat_id]);
            $current = $stmt->fetchColumn();
            $new = $current ? 0 : 1;

            $update_stmt = $db->prepare("UPDATE users SET notify_enabled = ? WHERE user_id = ?");
            $update_stmt->execute([$new, $chat_id]);

            sendMessage($chat_id, $new ? "✅ نوتیف بازی‌ها فعال شد." : "❌ نوتیف بازی‌ها غیرفعال شد.");
            showMainMenu($chat_id);
            break;

        case (strpos($callback_data, "start_predict_") === 0):
            $prefix = "start_predict_";
            $rest = substr($callback_data, strlen($prefix));
            $parts = explode("_", $rest, 3); // [match_id, home, away]
            
            if (count($parts) === 3) {
                showPredictionOptionsSimple($chat_id, $parts[1], $parts[2], $parts[0]);
            } else {
                sendMessage($chat_id, "❌ خطا در پردازش بازی.");
            }
            break;
    
        case ($callback_data == "start_prediction"):
            showTodayLeagues($chat_id);
            break;

        case (strpos($callback_data, "select_league_") === 0):
            $league_id = str_replace("select_league_", "", $callback_data);
            showMatchesByLeague($chat_id, $league_id);
            break;

        case (strpos($callback_data, "match_") === 0):
            $match_id = str_replace("match_", "", $callback_data);
            showMatchPredictionOptions($chat_id, $match_id);
            break;

        case (strpos($callback_data, "predict_") === 0):
            $parts = explode("_", $callback_data);

            $match_id = $parts[1] ?? null;
            $prediction = $parts[2] ?? null;

            if ($match_id && $prediction) {
                savePrediction($chat_id, $match_id, $prediction);
            } else {
                sendMessage($chat_id, "❌ خطا در ثبت پیش‌بینی.");
            }
            break;

        case (strpos($callback_data, "vote_") === 0):
            
                if (!rate_limit_check($chat_id, 'predict_vote', 1, 5)) {
                sendMessage($chat_id, "⏳ خیلی سریع داری پیش‌بینی می‌کنی! لطفا ۵ ثانیه صبر کن.");
                break;
            }
        
            // استخراج match_id و گزینه
            $message_id = $update['callback_query']['message']['message_id'];
            $parts = explode("_", $callback_data);
            $match_id = $parts[1] ?? null;
            $vote = $parts[2] ?? null;
        
            // تبدیل vote به prediction
            switch ($vote) {
                case '1': $prediction = 'home'; break;
                case 'X': $prediction = 'draw'; break;
                case '2': $prediction = 'away'; break;
                default: $prediction = null;
            }
        
            // اگر اطلاعات ناقص بود
            if (!$match_id || !$prediction) {
                sendMessage($chat_id, "❌ خطا در ثبت پیش‌بینی.");
                break;
            }
        
            // ۱. چک محدودیت ۵ پیش‌بینی
            $stmt = $db->prepare("SELECT total_predictions FROM users WHERE user_id = ?");
            $stmt->execute([$chat_id]);
            $total_predictions = (int)$stmt->fetchColumn();
            
            // بررسی عضویت در هر دو کانال
            if ($total_predictions >= 5 && 
               (!isUserInChannel($chat_id, '@GoalTiime') || !isUserInChannel($chat_id, '@KickPrediict'))) {
            
                $message = "🚫 شما بیش از ۵ پیش‌بینی رایگان انجام داده‌اید.\n\nبرای ادامه، باید در هر دو کانال عضو شوید:\n\n🔗 @GoalTiime\n🔗 @KickPrediict";
                sendMessage($chat_id, $message, [
                    'inline_keyboard' => [
                        [
                            ['text' => '🔗 عضویت در GoalTiime', 'url' => 'https://t.me/GoalTiime'],
                            ['text' => '🔗 عضویت در KickPrediict', 'url' => 'https://t.me/KickPrediict']
                        ]
                    ]
                ]);
                break;
            }
        
            // ۲. فقط یک کوئری برای گرفتن زمان بازی و بررسی قبلی بودن پیش‌بینی
            $stmt = $db->prepare("
                SELECT m.match_time,
                       (SELECT COUNT(*) FROM predictions p WHERE p.user_id = ? AND p.match_id = m.id) AS already
                FROM matches m
                WHERE m.id = ?
                LIMIT 1
            ");
            $stmt->execute([$chat_id, $match_id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
            if (!$row) {
                sendMessage($chat_id, "❌ بازی موردنظر یافت نشد.");
                break;
            }
        
            // اگر بازی شروع شده
            if (strtotime($row['match_time']) <= time()) {
                sendMessage($chat_id, "⛔️ زمان این بازی گذشته و امکان ثبت پیش‌بینی وجود ندارد.");
                break;
            }
        
            // اگر قبلاً پیش‌بینی شده
            if ($row['already'] > 0) {
                sendMessage($chat_id, "⛔️ شما قبلاً برای این بازی پیش‌بینی ثبت کرده‌اید.");
                break;
            }
        
            // ۳. ثبت پیش‌بینی با یک INSERT و آپدیت total_predictions در همان لحظه
            $db->beginTransaction();
            $stmt = $db->prepare("INSERT INTO predictions (user_id, match_id, prediction) VALUES (?, ?, ?)");
            $stmt->execute([$chat_id, $match_id, $prediction]);
        
            $stmt = $db->prepare("UPDATE users SET total_predictions = total_predictions + 1 WHERE user_id = ?");
            $stmt->execute([$chat_id]);
            $db->commit();
        
            // پاسخ نهایی
            editMessageText($chat_id, $message_id, "✅ پیش‌بینی شما ثبت شد.");
            break;
            
        case ($callback_data == "confirm_phone"):
            $keyboard = [
                "keyboard" => [
                    [["text" => "📱 ارسال شماره من", "request_contact" => true]]
                ],
                "resize_keyboard" => true,
                "one_time_keyboard" => true
            ];

            sendMessage($chat_id, "📲 لطفاً شماره موبایلت رو با دکمه زیر ارسال کن:", $keyboard);
            break;  
            
        case ($callback_data == "bot_rules"):
            showBotRules($chat_id, $message_id);
            break;
            
                    
        case ($callback_data == "bot_faq"):
            fact_rules($chat_id, $message_id);
            break;    
            
        case "top_users":
            $data = getTopUsersText($db);
            sendMessage($chat_id, $data['text'], json_encode($data['keyboard']), 'HTML');
            break;
            
    }
}

elseif (isset($text)) {
$user_id = $update["message"]["from"]["id"];
    $first_name = $update["message"]["from"]["first_name"] ?? '';
    $username = $update["message"]["from"]["username"] ?? '';

    ensureUserExists($user_id, $first_name, $username);

    $chat_id = $update["message"]["chat"]["id"];
    $text = $update["message"]["text"];
    
        // بررسی اینکه آیا کاربر در جدول pool_sessions فعال است
$stmt = $db->prepare("SELECT match_id, option_selected FROM pool_sessions WHERE user_id = ?");
$stmt->execute([$chat_id]);
$session = $stmt->fetch(PDO::FETCH_ASSOC);

if ($session) {

    // اگر ورودی عدد نبود، خطا بده و وضعیت رو ریست کن
    if (!ctype_digit($text)) {
        sendMessage($chat_id, "❌ اعداد باید فقط به انگلیسی وارد شوند. \n✅ لطفا برای ادامه ربات را دوباره استارت کنید.");

        $stmt = $db->prepare("DELETE FROM pool_sessions WHERE user_id = ?");
        $stmt->execute([$chat_id]);

        return;
    }

    $amount = (int) $text;
    $min = 50;
    $max = 1500;

    // بررسی حداقل و حداکثر
    if ($amount < $min || $amount > $max) {
        sendMessage($chat_id, "⚠️ مقدار وارد شده معتبر نیست.\nمقدار باید بین ۵۰ و ۱۵۰۰ توکن باشد.");

        $stmt = $db->prepare("DELETE FROM pool_sessions WHERE user_id = ?");
        $stmt->execute([$chat_id]);

        return;
    }

    // بررسی موجودی کاربر
    $score = getCachedUserScore($chat_id);

    if ($score < $amount) {
        sendMessage($chat_id, "❌ موجودی کافی نیست. موجودی فعلی شما: " . convertEntofanumber($score) . " توکن");

        $stmt = $db->prepare("DELETE FROM pool_sessions WHERE user_id = ?");
        $stmt->execute([$chat_id]);

        return;
    }

    // بررسی اینکه بازی هنوز شروع نشده
    $stmt = $db->prepare("SELECT match_time FROM matches WHERE id = ?");
    $stmt->execute([$session['match_id']]);
    $match_time = $stmt->fetchColumn();

    if (!$match_time || strtotime($match_time) <= time()) {
        sendMessage($chat_id, "⛔ زمان پیش‌بینی برای این بازی به پایان رسیده است.");

        $stmt = $db->prepare("DELETE FROM pool_sessions WHERE user_id = ?");
        $stmt->execute([$chat_id]);

        return;
    }

    // ✅ حالا که تایید شد بازی هنوز شروع نشده:

    // کم کردن توکن از حساب کاربر
    $stmt = $db->prepare("UPDATE users SET score = score - ? WHERE user_id = ?");
    $stmt->execute([$amount, $chat_id]);

    // ذخیره سرمایه‌گذاری نهایی در جدول pool_investments
    $stmt = $db->prepare("
        INSERT INTO pool_investments (user_id, match_id, option_selected, tokens)
        VALUES (?, ?, ?, ?)
    ");
    $stmt->execute([$chat_id, $session['match_id'], $session['option_selected'], $amount]);

    // حذف وضعیت کاربر از جدول pool_sessions (در پایان موفقیت‌آمیز)
    $stmt = $db->prepare("DELETE FROM pool_sessions WHERE user_id = ?");
    $stmt->execute([$chat_id]);

    // پیام تایید + نمایش دو دکمه
    $text = "✅ سرمایه‌گذاری شما با موفقیت انجام شد.\n\n"
          . "🎉 موفق باشید! حالا می‌تونی وضعیت استخر رو ببینی یا یک بازی دیگه رو انتخاب کنی.";

    $keyboard = [
        [['text' => '📊 وضعیت استخر', 'callback_data' => "pool_match_{$session['match_id']}"]],
        [['text' => '🔙 بازگشت به بازی‌ها', 'callback_data' => 'start_pool']]
    ];

    sendMessage($chat_id, $text, json_encode([
        'inline_keyboard' => $keyboard
    ]), 'HTML');

    return;
}
    
        // بررسی اینکه آیا استارت با پارامتر دعوت بوده یا نه
if (strpos($text, "/start ref_") === 0) {
    $referrer_id = str_replace("/start ref_", "", $text);
    $user_id = (int)$chat_id;

    // جلوگیری از خوددعوتی
    if ($referrer_id == $user_id) {
        sendMessage($chat_id, "❌ نمی‌تونی از لینک دعوت خودت استفاده کنی!");
        showMainMenu($chat_id);
        return;
    }

    // بررسی اینکه کاربر قبلاً در users هست یا نه و آیا invited_by دارد
    $stmt = $db->prepare("SELECT invited_by FROM users WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $invited_by = $stmt->fetchColumn();

    if ($invited_by) {
        // قبلاً دعوت ثبت شده
        sendMessage($chat_id, "👋 خوش اومدی! حساب تو قبلاً ثبت شده.");
        return;
    }

    // ثبت دعوت اگر قبلاً ثبت نشده بود
    handleReferral($user_id, $referrer_id);
    sendMessage($chat_id, "🎉 خوش آمدی! دعوت‌نامه با موفقیت ثبت شد.");
    showMainMenu($chat_id);
    return;
}

    if ($text == "/start") {
        clearUserSession($chat_id);
        showMainMenu($chat_id);
        return;
    }
    
        // اگر کاربر در وضعیت خرید قرار دارد (منتظر ارسال ۴ رقم کارت)
    $session = getUserSession($chat_id);
    if ($session && $session['mode'] === 'buy_mode') {
    
        // مقدار tokens از دیتای ذخیره شده در session
        $data = is_string($session['data']) ? json_decode($session['data'], true) : $session['data'];
        $tokens_to_buy = (int)($data['tokens_to_buy'] ?? 0);
    
        // اعتبارسنجی پیام (۴ رقم آخر کارت)
        if (!preg_match('/^\d{4}$/', $text)) {
            sendMessage($chat_id, "⛔ لطفاً فقط <b>۴ رقم آخر کارت</b> را ارسال کنید.", null, 'HTML');
            return;
        }
    
        $last4digits = $text;
    
        // ثبت درخواست خرید در جدول buy_requests
        $stmt = $db->prepare("
            INSERT INTO buy_requests (user_id, tokens_requested, card_last4, created_at, status)
            VALUES (?, ?, ?, NOW(), 'pending')
        ");
        $stmt->execute([$user_id, $tokens_to_buy, $last4digits]);
    
        // پاک کردن session از دیتابیس
        clearUserSession($chat_id);
    
        // اطلاع به کاربر
        sendMessage($chat_id, "✅ درخواست خرید شما ثبت شد.\nپس از تایید پرداخت توسط ادمین، توکن‌های شما به حساب کاربری‌تان افزوده خواهد شد.");
        return;
    }

    // ✅ اگر کاربر در حالت پشتیبانی باشه
    $session = getUserSession($chat_id);
    
    if ($session && $session['mode'] === 'support_mode') {
        // بعد از دریافت پیام، session را پاک کن
        clearUserSession($chat_id);
    
        // پیام کاربر را به جدول تیکت‌ها ذخیره کن
        $stmt = $db->prepare("INSERT INTO support_tickets (user_id, message) VALUES (?, ?)");
        $stmt->execute([$chat_id, $text]);
    
        // اطلاع به ادمین
        $admin_id = 745398320; // آیدی ادمین
        $user_link = "tg://user?id=$chat_id";
        $msg = "📬 تیکت جدید از کاربر:\n$user_link\n\n🔍 برای پاسخ به تیکت وارد پنل شو.";
        sendMessage($admin_id, $msg);
    
        // پاسخ به کاربر
        sendMessage($chat_id, "✅ پیام شما ثبت شد. پشتیبانی به‌زودی پاسخ خواهد داد.");
        return;
    }

    // 👇 این بخش مربوط به /start هست
    if (strpos($text, "/start") !== false) {
        $first_name = $update["message"]["from"]["first_name"] ?? '';
        $username = $update["message"]["from"]["username"] ?? '';
        $stmt = $db->prepare("
            INSERT INTO users (user_id, first_name, username, score)
            VALUES (?, ?, ?, 0)
            ON DUPLICATE KEY UPDATE
                first_name = VALUES(first_name),
                username = VALUES(username)
        ");
        $stmt->execute([$chat_id, $first_name, $username]);
        showMainMenu($chat_id);
        return;
    }

    sell_mode:
    $session = getUserSession($chat_id);
    if ($session && $session['mode'] === 'sell_mode') {
    
        $data = is_array($session['data']) ? $session['data'] : (json_decode($session['data'], true) ?? []);
        $step = $data['step'] ?? 'step_1';
    
    if ($step == "step_1") {
    
        if (!isset($message["contact"])) {
            $keyboard = [
                "keyboard" => [
                    [["text" => "📱 ارسال شماره من", "request_contact" => true]]
                ],
                "resize_keyboard" => true,
                "one_time_keyboard" => true
            ];
            sendMessage($chat_id, "📲 برای ادامه، لطفاً شماره موبایل خودت رو با دکمه زیر ارسال کن:", $keyboard);
            return;
        }
    
        $contact = $message["contact"];
        $phone = str_replace(' ', '', $contact["phone_number"]);
        $sender_id = $message["from"]["id"];
    
        // فقط شماره‌ی خود کاربر مجازه
        if ($contact["user_id"] != $sender_id) {
            sendMessage($chat_id, "⛔ فقط شماره‌ای که با همین حساب وارد تلگرام شدی مجازه.");
            return;
        }
    
        // فقط ایران، آلمان و اتریش مجازه
        if (!preg_match('/^\+?(98|49|43)\d{8,12}$/', $phone)) {
            sendMessage($chat_id, "⛔ فقط شماره‌های ایران 🇮🇷، آلمان 🇩🇪 یا اتریش 🇦🇹 مجاز هستند.");
            return;
        }
    
        // اگر ایران بود، به 09 تبدیل کن
        if (strpos($phone, "+98") === 0) {
            $phone = "0" . substr($phone, 3);
        }
    
        // بررسی اینکه شماره موبایل در حساب دیگری نباشه
        $stmt = $db->prepare("SELECT user_id FROM users WHERE phone_number = ? AND user_id != ?");
        $stmt->execute([$phone, $chat_id]);
        if ($stmt->fetchColumn()) {
            sendMessage($chat_id, "⛔ این شماره موبایل قبلاً در حساب دیگری ثبت شده و امکان استفاده مجدد وجود ندارد.");
            return;
        }
    
        // بررسی شماره ثبت‌شده قبلی برای همین کاربر
        $stmt = $db->prepare("SELECT phone_number FROM users WHERE user_id = ?");
        $stmt->execute([$chat_id]);
        $registered_phone = $stmt->fetchColumn();
    
        if ($registered_phone) {
            if ($registered_phone !== $phone) {
                sendMessage($chat_id, "⛔ شماره موبایل ارسال‌شده با شماره قبلی شما متفاوت است و امکان تغییر آن وجود ندارد.");
                return;
            }
        } else {
            $stmt = $db->prepare("UPDATE users SET phone_number = ? WHERE user_id = ?");
            $stmt->execute([$phone, $chat_id]);
        }
    
        // رفتن به مرحله 2
        $data['phone'] = $phone;
        $tokens = $data['tokens'] ?? $data['sell_amount'] ?? null;  // هر کدوم بود
        setUserSession($chat_id, 'sell_mode', json_encode([
            'step'   => 'step_2',
            'tokens' => $tokens,
            'phone'  => $data['phone']
        ]));
    
        sendMessage($chat_id, "💳 شماره کارت ۱۶ رقمی بانک خود را وارد کنید: \n\n ⚠️ پولات همیشه به همین شماره کارت واریز میشه و امکان تغییرش وجود نداره! ");
        return;
    }

    if ($step == "step_2") {
        $card = trim($text);

        if (!preg_match('/^\d{16}$/', $card)) {
            sendMessage($chat_id, "⛔ فقط ۱۶ رقم کارت بانکی مجاز است.");
            return;
        }

        $stmt = $db->prepare("SELECT user_id FROM users WHERE full_card_number = ? AND user_id != ?");
        $stmt->execute([$card, $chat_id]);
        if ($stmt->fetchColumn()) {
            sendMessage($chat_id, "⛔ این شماره کارت قبلاً در حساب دیگری ثبت شده و امکان استفاده مجدد وجود ندارد.");
            return;
        }

        $stmt = $db->prepare("SELECT full_card_number FROM users WHERE user_id = ?");
        $stmt->execute([$chat_id]);
        $registered_card = $stmt->fetchColumn();

        if ($registered_card) {
            if ($registered_card !== $card) {
                sendMessage($chat_id, "⛔ شماره کارت واردشده با شماره کارت تاییدشده قبلی شما متفاوت است و امکان تغییر آن وجود ندارد.");
                return;
            }
        } else {

            $stmt = $db->prepare("UPDATE users SET full_card_number = ? WHERE user_id = ?");
            $stmt->execute([$card, $chat_id]);
        }

        $data['card'] = $card;
            $tokens = $data['tokens'] ?? $data['sell_amount'] ?? null;
            setUserSession($chat_id, 'sell_mode', json_encode([
                'step'   => 'step_3',
                'tokens' => $tokens,
                'phone'  => $data['phone'],
                'card'   => $data['card']
            ]));

        sendMessage($chat_id, "🧾 لطفاً نام کامل خود را وارد کنید (مطابق با کارت بانکی).");
        return;
    }

    // STEP 3: دریافت نام کامل و ثبت درخواست
    if ($step == "step_3") {
        $realname = trim($text);
        if (mb_strlen($realname) < 3) {
            sendMessage($chat_id, "⚠️ لطفاً نام کامل واقعی معتبر وارد کن.");
            return;
        }

        $data['real_name'] = $realname;
        // NEW: قفل کردن نام واقعی پس از اولین ثبت
        $stmt = $db->prepare("SELECT real_name FROM users WHERE user_id = ?");
        $stmt->execute([$chat_id]);
        $existing_name = $stmt->fetchColumn();
        
        if ($existing_name) {
            if ($existing_name !== $realname) {
                sendMessage($chat_id, "⛔ نام واقعی شما قبلاً به «{$existing_name}» ثبت شده و قابل تغییر نیست.");
                return;
            }
        } else {
            $stmt = $db->prepare("UPDATE users SET real_name = ? WHERE user_id = ?");
            $stmt->execute([$realname, $chat_id]);
        }

        // ثبت درخواست در جدول sell_requests
        $stmt = $db->prepare("
            INSERT INTO sell_requests (user_id, requested_tokens, phone_number, full_card_number, real_name, payment_method, request_status)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $chat_id,
            (int)($data['tokens'] ?? 0),
            $data['phone'],
            $data['card'],
            $data['real_name'],
            'کارت به کارت',
            'pending'
        ]);

        $admin_id = 745398320;
        $msg = "📥 درخواست فروش جدید:\n"
             . "👤 آیدی: $chat_id\n"
             . "🔢 مقدار: " . $data['tokens'] . "\n"
             . "📞 شماره: " . $data['phone'] . "\n"
             . "💳 کارت: " . $data['card'] . "\n"
             . "🧾 نام: " . $data['real_name'];
        sendMessage($admin_id, $msg);

        // پاک کردن session
        clearUserSession($chat_id);

        sendMessage($chat_id, "✅ درخواست فروش شما ثبت شد و در حال بررسی است.");
        return;
    }
}
    
    // ✅ فقط برای پیام‌های ناشناخته بدون حالت خاص
    sendMessage($chat_id, "سلام! ربات روشنه  ✅\nبرای نمایش منو از /start استفاده کنید.");
}
?>