<?php
declare(strict_types=1);

if (defined('APP_BOOTSTRAPPED')) {
    return;
}
define('APP_BOOTSTRAPPED', true);


// منطقه زمانی و خطاها
date_default_timezone_set('Asia/Tehran');
ini_set('display_errors','0');
error_reporting(E_ALL);

// هدرهای امنیتی پایه
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: SAMEORIGIN');
header('Referrer-Policy: no-referrer');

$configPath = '/home1/footbal1/secure_config/config.php';
if (!file_exists($configPath)) {
    http_response_code(500);
    exit('Config file not found');
}
$config = require $configPath;

// === اتصال امن به دیتابیس ===
try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
        $config['db_user'],
        $config['db_pass'],
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_EMULATE_PREPARES   => false,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    http_response_code(500);
    exit('Database error');
}

// ثابت‌ها
define('BOT_TOKEN', $config['token'] ?? '');
define('ADMINS', $config['admins'] ?? []);

// === هلسپرها ===
function safe_str(string $s, int $max = 128, string $pattern = '/^[A-Za-z0-9:_\-\|\.]+$/'): string {
    if (strlen($s) > $max) return '';
    if ($pattern && !preg_match($pattern, $s)) return '';
    return $s;
}

function rate_limit(string $key, int $limit = 10, int $window = 60): bool {
    $now = time();
    $file = sys_get_temp_dir() . '/rl_' . md5($key);
    $hits = @json_decode(@file_get_contents($file), true) ?: [];
    $hits = array_filter($hits, fn($t) => $t > $now - $window);
    if (count($hits) >= $limit) return false;
    $hits[] = $now;
    @file_put_contents($file, json_encode($hits));
    return true;
}
