<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

date_default_timezone_set("Asia/Tehran");

define('SECURE_ACCESS', true);

$config = require '/home1/footbal1/secure_config/config.php';
require_once __DIR__ . '/functions.php';

$website = "https://api.telegram.org/bot" . $config['token'] . "/";
$chat_id = $_GET['user_id'] ?? '@KickPrediict';

$logFile = __DIR__ . '/log/top_users_sent.txt';
$today = date('Y-m-d');

// اگر امروز قبلاً پیام ارسال شده، متوقف شو (فقط برای کانال)
if (str_starts_with($chat_id, '@') && file_exists($logFile) && trim(file_get_contents($logFile)) === $today) {
    exit("⏳ جدول برترین‌ها قبلاً برای کانال ارسال شده است.\n");
}

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", 
        $config['db_user'], 
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

$data = getTopUsersText($db);

$is_channel = str_starts_with($chat_id, '@');

$params = [
    'chat_id' => $chat_id,
    'text' => $data['text'],
    'parse_mode' => 'HTML'
];

if (!$is_channel) {
    $params['reply_markup'] = json_encode($data['keyboard'], JSON_UNESCAPED_UNICODE);
}

file_get_contents($website . "sendMessage?" . http_build_query($params));

// ثبت ارسال موفق (فقط برای کانال)
if ($is_channel) {
    if (!is_dir(dirname($logFile))) {
        mkdir(dirname($logFile), 0777, true);
    }
    file_put_contents($logFile, $today);
}
