<?php
date_default_timezone_set("Asia/Tehran");

define('SECURE_ACCESS', true);

require __DIR__ . '/functions.php';
$config = require '/home1/footbal1/secure_config/config.php';

$logFile = __DIR__ . '/log/today_matches_sent.txt';
$today = date('Y-m-d');

// اگر امروز قبلاً پیام ارسال شده، متوقف شو
if (file_exists($logFile) && trim(file_get_contents($logFile)) === $today) {
    exit("⏳ بازی‌های امروز قبلاً ارسال شده‌اند.\n");
}

$token = $config['token'];
$chat_id = '@KickPrediict';

// اتصال به دیتابیس
try {
    $db = new PDO("mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", $config['db_user'], $config['db_pass']);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// گرفتن پیام بازی‌های امروز
$message = getTodayMatchesText($db);

if ($message && strlen($message) > 10) {
    sendTelegramMessage($chat_id, $message, $token);

    if (!is_dir(dirname($logFile))) {
        mkdir(dirname($logFile), 0777, true);
    }

    file_put_contents($logFile, $today); // ثبت ارسال موفق
}

function sendTelegramMessage($chat_id, $text, $token) {
    $url = "https://api.telegram.org/bot$token/sendMessage";
    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $text
    ];

    $opts = [
        "http" => [
            "method" => "POST",
            "header" => "Content-Type:application/x-www-form-urlencoded",
            "content" => http_build_query($post_fields)
        ]
    ];

    file_get_contents($url, false, stream_context_create($opts));
}
