<?php
date_default_timezone_set("Asia/Tehran");

define('SECURE_ACCESS', true);

$logFile = __DIR__ . '/log/last_sent.txt';  // مسیر ذخیره تاریخ آخرین ارسال
$config = require '/home1/footbal1/secure_config/config.php';
require_once __DIR__ . '/functions.php';

$website = "https://api.telegram.org/bot" . $config['token'];
$chat_id = '@KickPrediict';

$yesterday = date('Y-m-d', strtotime('-1 day'));

// بررسی اینکه آیا برای دیروز پیام قبلاً ارسال شده یا نه
if (file_exists($logFile) && trim(file_get_contents($logFile)) === $yesterday) {
    exit("⏳ نتایج روز قبل قبلاً ارسال شده.\n");
}

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4", 
        $config['db_user'], 
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    exit;
}

// گرفتن نتایج روز قبل
$stmt = $db->prepare("
    SELECT l.name AS league_name, m.team_home, m.team_away, m.result
    FROM matches m
    JOIN leagues l ON l.id = m.league_id
    WHERE m.match_day = ?
      AND m.result IS NOT NULL
      AND m.result != ''
    ORDER BY l.name ASC, m.match_time ASC
");
$stmt->execute([$yesterday]);
$matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($matches)) {
    $text = "📭 هنوز هیچ نتیجه‌ای برای دیروز ثبت نشده.";
} else {
    $text  = "<b>📊 نتایج کامل بازی‌های دیروز را در لیست زیر ببینید 👇</b>\n";
    $text .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n";

    $currentLeague = '';
    foreach ($matches as $m) {
        $league = getleagues($m['league_name']); // تابعی که اسم لیگ رو فارسی برگردونه
        if ($league !== $currentLeague) {
            // فاصله قبل از لیگ جدید (به جز اولین لیگ)
            if ($currentLeague !== '') {
                $text .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n";
            }
            $text .= "🏆 <b>$league</b>\n\n";
            $currentLeague = $league;
        }

        $home = getTeamName($m['team_home']);
        $away = getTeamName($m['team_away']);
        $result = matchText($m['result'], $home, $away);

        $text .= "⚽️ {$home} vs {$away}\n";
        $text .= "☑️ $result\n\n";
    }
}

// ارسال پیام
file_get_contents($website . "/sendMessage?" . http_build_query([
    'chat_id' => $chat_id,
    'text' => $text,
    'parse_mode' => 'HTML'
]));

if (!is_dir(dirname($logFile))) {
    mkdir(dirname($logFile), 0777, true);
}

file_put_contents($logFile, $yesterday);

echo "✅ نتایج دیروز با موفقیت ارسال شد.\n";
