<?php

if (!defined('APP_BOOTSTRAPPED')) {
    require __DIR__ . '/../_guard.php';
}

function showUserScore($chat_id) {
    $score = getCachedUserScore($chat_id);
    return $score;
}

function showLeaderboard($chat_id) {
    global $db;

    $stmt = $db->query("SELECT first_name, score FROM users ORDER BY score DESC LIMIT 15");
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $text = "🏆 جدول برترین‌ها:\n\n";
    $rank = 1;

    foreach ($rows as $row) {
        $name = htmlspecialchars($row['first_name'] ?: 'بدون‌نام', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        $uname = ''; // حذف نمایش username
        $text .= "{$rank}. {$name} - {$row['score']} امتیاز\n";
        $rank++;
    }
    sendMessage($chat_id, $text);
}
