<?php

require __DIR__ . '/../_guard.php';

function showMainMenu($chat_id) {
    global $db_connected;
    // گرفتن وضعیت نوتیف از دیتابیس
    global $db;
    $stmt = $db->prepare("SELECT notify_enabled FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $status = $stmt->fetchColumn();
    $notify_text = $status ? "📢 نوتیف بازی‌ها: ✅ فعال" : "📢 نوتیف بازی‌ها: ❌ غیرفعال";

    $buttons = [
        [['text' => '📅 بازی‌های امروز ', 'callback_data' => 'predict_today']],
        [['text' => '📝 پیش‌بینی‌ رایگان', 'callback_data' => 'start_prediction']],
        [['text' => '💰 سرمایه‌گذاری‌ در‌ استخر!', 'callback_data' => 'pool_invest']],
        [['text' => '👤 پروفایل کاربری', 'callback_data' => 'profile_menu']],
        [['text' => '🏆 جدول برترین‌ها', 'callback_data' => 'top_users']],
        [
            ['text' => '💵 فروش توکن', 'callback_data' => 'token_shop'],
            ['text' => "🛒 خرید توکن سرمایه گذاری", 'callback_data' => "open_token_shop"]
        ],
        [['text' => "🎁 امتیاز بیشتر با دعوت دوستان", 'callback_data' => 'invite_friends'] ],
        [['text' => '📜 قوانین و مقررات استفاده از ربات', 'callback_data' => 'bot_rules']],
        [
            ['text' => '📞 پشتیبانی', 'callback_data' => 'support'],
            ['text' => '⁉️ پاسخ به سوالات', 'callback_data' => 'bot_faq']
            ],
    ];

$msg = $db_connected
    ? "👋 به ربات پیش‌بینی فوتبال خوش اومدی!\n\n".
      "⚽ بازی‌های فوتبال رو رایگان پیش‌بینی کن!\n".
      "🎁 امتیاز رایگان بگیر!\n".
      "💰 بفروش یا سرمایه‌گذاری کن!\n\n".
      "📜 قبل از هر کاری حتما قوانین ربات رو مطالعه کن."
    : "به ربات خوش اومدی، ولی اتصال به دیتابیس قطع شده! ❌";

sendInlineKeyboard($chat_id, $msg, $buttons);
}

function showPredictionsMenu($chat_id) {
    $buttons = [
        [['text' => "📅 پیش‌بینی‌های فعال", 'callback_data' => "active_predictions"]],
        [['text' => "🎯 نتایج پیش‌بینی‌ها", 'callback_data' => "past_predictions"]],
        // [['text' => "📚 تاریخچه پیش‌بینی‌ها", 'callback_data' => "prediction_history"]],
        [['text' => "🔙 بازگشت", 'callback_data' => "profile_menu"]]
    ];
    sendInlineKeyboard($chat_id, "👇 اینجا آخرین پیش‌بینی‌هاتو می‌بینی.\n اگه می‌خوای همه‌ی سوابقت رو کامل ببینی، برو به پروفایل حرفه‌ای", $buttons);
}

function getProfileButtons($chat_id) {
    global $db;

    // دریافت وضعیت نوتیف
    $stmt = $db->prepare("SELECT notify_enabled FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $status = $result['notify_enabled'] ?? 0;
    $notify_text = $status ? "📢 نوتیف بازی‌ها: ✅ فعال" : "📢 نوتیف بازی‌ها: ❌ غیرفعال";

    // ساخت و ذخیره توکن جدید در هر بار کلیک
    $token = bin2hex(random_bytes(16));  // توکن 32 کاراکتری
    $stmt = $db->prepare("UPDATE users SET access_token = ? WHERE user_id = ?");
    $stmt->execute([$token, $chat_id]);

    // ساخت لینک با توکن جدید
    $link = "https://footballpredict.space/miniapp_profile/index.php?token={$token}";

    return [
        [['text' => '📋 سرمایه‌گذاری‌های من', 'callback_data' => 'my_investments']],
        [['text' => '🔖 پیش‌بینی‌های رایگان من', 'callback_data' => 'my_predictions']],
        [['text' => '👤 پروفایل حرفه‌ای من (پیشنهاد ادمین)', 'url' => $link]],
        [['text' => $notify_text, 'callback_data' => 'toggle_notify']],
        [['text' => '🔙 بازگشت', 'callback_data' => 'start']]
    ];
}
