<?php
require_once __DIR__ . '/persiannames.php';
const TOKEN    = '7615955369:AAFCsNKX5w-Jbq-b2Ue5PvxKTcHRda5vSgY';

$user_score_cache = [];
function bot(string $method, array $data = []): array {
    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL            => 'https://api.telegram.org/bot' . TOKEN . '/' . $method,
        CURLOPT_POSTFIELDS     => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/x-www-form-urlencoded'],
        CURLOPT_TIMEOUT        => 10, 
    ]);

    $result = curl_exec($curl);

    if (curl_errno($curl)) {
        error_log('cURL Error: ' . curl_error($curl));
        curl_close($curl);
        return ['ok' => false, 'error' => curl_error($curl)];
    }

    curl_close($curl);

    $response = json_decode($result, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_log('JSON Decode Error: ' . json_last_error_msg());
        return ['ok' => false, 'error' => 'Invalid JSON response'];
    }

    return $response;
}

function answerCallbackQuery($callbackId,$text){

    return bot('answerCallbackQuery',[
        'callback_query_id'=>$callbackId,
        'text'=>"$text",
        'show_alert' => false
    ]);
}

function convertEntofanumber($text) {
    $persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    return preg_replace_callback('/[0-9]/', function($match) use ($persianNumbers) {
        return $persianNumbers[intval($match[0])];
    }, $text);
}

function sendInlineKeyboard($chat_id, $text, $buttons) {
    global $website;
    $keyboard = ["inline_keyboard" => $buttons];
    $data = [
        "chat_id" => $chat_id,
        "text" => $text,
        'parse_mode' => 'HTML',
        "reply_markup" => json_encode($keyboard)
    ];
    file_get_contents($website . "sendMessage?" . http_build_query($data));
}

function matchText($code, $home, $away) {
    $code = strtolower($code); // تبدیل به حروف کوچک برای اطمینان
    if ($code === 'home') return "برد $home";
    if ($code === 'draw') return "مساوی";
    if ($code === 'away') return "برد $away";
    return "نامشخص";
}

function getCachedUserScore($chat_id) {
    global $user_score_cache, $db;

    if (isset($user_score_cache[$chat_id])) {
        return $user_score_cache[$chat_id];
    }

    $stmt = $db->prepare("SELECT score FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $score = $stmt->fetchColumn() ?: 0;

    $user_score_cache[$chat_id] = $score;
    return $score;
}

function sendMessage($chat_id, $text, $keyboard = null, $parse_mode = 'HTML') {
    global $website;
    // ⛔️ گارد: اگر chat_id خالی/نامعتبر بود، لاگ کن و برگرد
    if (empty($chat_id)) {
        $bt = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 5);
        $caller = isset($bt[1]['file'], $bt[1]['line']) ? ($bt[1]['file'].':'.$bt[1]['line']) : 'unknown';
        error_log('[sendMessage] EMPTY chat_id | caller='.$caller.' | text_snip='.mb_substr($text ?? '',0,40));
        return false;
    }
    $url = $website . "sendMessage";

    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => $parse_mode
    ];

    if ($keyboard) {
        // اگر کیبورد آرایه است، آن را به JSON تبدیل کنید
        if (is_array($keyboard)) {
            $post_fields['reply_markup'] = json_encode($keyboard, JSON_UNESCAPED_UNICODE);
        } 
        // اگر کیبورد از قبل JSON است (رشته است و معتبر است)، مستقیماً استفاده کنید
        elseif (is_string($keyboard) && json_decode($keyboard) !== null) {
            $post_fields['reply_markup'] = $keyboard;
        }
        // اگر فرمت نامعتبر است، خطا لاگ کنید
        else {
            error_log('Invalid keyboard format: ' . print_r($keyboard, true));
            return false;
        }
    }
    
// جایگزینِ محاسبه caller قبلی
$bt = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 15);
$caller = 'unknown';
foreach ($bt as $f) {
    if (!isset($f['file'])) continue;
    // اولین فایلی که خودِ helpers نیست
    if (strpos($f['file'], 'functions.php') === false) {
        $fn = isset($f['function']) ? $f['function'] : '';
        $caller = $f['file'] . ':' . ($f['line'] ?? '?') . ($fn ? ' ['.$fn.']' : '');
        break;
    }
}
// error_log('[sendMessage] -> chat_id='.$chat_id.' | caller='.$caller.' | text_snip='.mb_substr($text ?? '',0,40));

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    if (is_array($post_fields)) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/x-www-form-urlencoded'
        ]);
    } else {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    }
    
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    
    if (curl_errno($ch)) {
        error_log('cURL error: ' . curl_error($ch));
    }
    
    curl_close($ch);
    
    $response = json_decode($result, true);
    if (isset($response['ok']) && $response['ok'] === true) {
        return true;
    } else {
        error_log('Telegram API error: ' . $result);
        return false;
    }
}

function getTodayMatchesText($db) {
    $stmt = $db->query("
        SELECT l.name AS league, m.team_home, m.team_away, m.match_time
        FROM matches m
        JOIN leagues l ON m.league_id = l.id
        WHERE m.match_day = CURDATE()
        ORDER BY l.name, m.match_time
    ");
    $matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($matches)) {
        return "📅 هیچ بازی‌ای برای امروز ثبت نشده.";
    }

    $text = "📅 بازی‌های امروز برای پیش‌بینی:\n";
    $currentLeague = '';

    foreach ($matches as $match) {
        if ($match['league'] !== $currentLeague) {
            $currentLeague = $match['league'];
            $leagueName = getleagues($currentLeague);
            $text .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n\n";
            $text .= "🏆 " . $leagueName . ":\n";

            }
        $home = getTeamName($match['team_home']);
        $away = getTeamName($match['team_away']);
        $time = convertEntofanumber(date("H:i", strtotime($match['match_time'])));

        $text .= "🔹 {$home} vs {$away} - $time\n";
    }
    
    $text .= "ــــــــــــــــــــــــــــــــــــــــــــــ";
    $text .= "\n👟 برای پیش‌بینی وارد ربات شو\n👉 @KickPredict_bot";

    return $text;
}

function getTodayResultsText($db) {
    $stmt = $db->query("
        SELECT l.name AS league, m.team_home, m.team_away, m.result
        FROM matches m
        JOIN leagues l ON m.league_id = l.id
        WHERE m.match_day = DATE_SUB(CURDATE(), INTERVAL 1 DAY) AND m.result IS NOT NULL AND m.result != ''
        ORDER BY l.name, m.match_time
    ");
    $matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($matches)) {
        return "📭 هنوز نتیجه‌ای برای امروز ثبت نشده.";
    }

    $text = "📈 نتایج بازی‌های امروز:\n\n";
    $currentLeague = '';

    foreach ($matches as $match) {
        if ($match['league'] !== $currentLeague) {
            $currentLeague = $match['league'];
            $text .= "🏆 " . $currentLeague . ":\n";
        }

        $resultText = matchText($match['result']);
        $text .= "🔹 {$match['team_home']} vs {$match['team_away']} → $resultText\n";
    }

    $text .= "\n📲 برای پیش‌بینی بازی‌های آینده وارد ربات شو\n👉 @KickPredict_bot";
    return $text;
}

function getTopUsersText($db) {
    $stmt = $db->query("
        SELECT user_id, score, username, first_name
        FROM users
        ORDER BY score DESC
        LIMIT 7
    ");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($users)) {
        return [
            'text' => "⛔ هنوز هیچ کیوب کوینی ثبت نشده.",
            'keyboard' => [
                'inline_keyboard' => [
                    [
                        ['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                    ]
                ]
            ]
        ];
    }

    $text = "👑 <b>جدول قهرمانان ربات پیش‌بینی!</b>\n\n"
    . "🔥 این‌ها حرفه‌ای‌ترین بازیکن‌ها و بیشترین کوین هارو دارن:\n\n";
    $rank = 1;

    foreach ($users as $user) {
        $name = trim($user['first_name'] ?? '');
        if ($name === '') {
            if (!empty($user['username'])) {
                $name = '@' . $user['username'];
            } else {
                $name = 'کاربر ' . $user['user_id'];
            }
        }
        $name = htmlspecialchars($name, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        $text .= "{$rank}. $name – امتیاز: {$user['score']}\n";
        $rank++;
    }

    $text .= "\n✨ تو هم رقابت کن → @KickPredict_bot";
    $text = convertEntofanumber($text);
    return [
        'text' => $text,
        'keyboard' => [
            'inline_keyboard' => [
                [
                    ['text' => '🔙 بازگشت به منوی اصلی', 'callback_data' => 'main_menu']
                ]
            ]
        ]
    ];
}

function showMatchesFromAPI($chat_id) {
    global $db;
    // global $My_Ligs;

    $today = date("Y-m-d");

    // گرفتن لیست لیگ‌های امروز از دیتابیس
    $query = "
        SELECT l.id AS league_id, l.name AS league_name,
               m.id AS match_id, m.team_home, m.team_away, m.match_time
        FROM leagues l
        JOIN matches m ON m.league_id = l.id
        WHERE m.match_day = ?
    ";
    
    $params = [$today];

    $query .= " ORDER BY l.name ASC, m.match_time ASC";

    $stmt = $db->prepare($query);
    $stmt->execute($params);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        sendMessage($chat_id, "📭 هیچ بازی‌ای برای امروز پیدا نشد.");
        return;
    }

    $gamesText = "📅 <b>لیست بازی‌هایی که امروز برگزار می‌شوند.</b>\n
‼️️ توجه: بازی‌هایی که زمان برگزاری‌شان گذشته باشد، دیگر در لیست نمایش داده نمی‌شوند.\n";
    $gamesText .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n";

    $printedLeagues = [];
    $index = 1;

    foreach ($rows as $row) {
        $leagueId = $row['league_id'];
        $leagueName = "<b>" . getleagues($row['league_name']) . "</b>\n";

        // نمایش نام لیگ یک بار
        if (!in_array($leagueId, $printedLeagues)) {
            // اگر قبلا یک لیگ چاپ شده، قبل از شروع لیگ جدید خط جداکننده اضافه کن
            if (!empty($printedLeagues)) {
                $gamesText .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n";
            }

            $gamesText .= "🏆 $leagueName\n";
            $printedLeagues[] = $leagueId;
            $num = 0;
        }

        // اگر زمان بازی گذشته باشد، نمایش داده نشود
        if ($row['match_time'] <= date('Y-m-d H:i:s')) {
            continue;
        }

        $num++;
        $timeFormatted = date("H:i", strtotime($row['match_time']));
        $home = getTeamName($row['team_home']);
        $away = getTeamName($row['team_away']);

        $gamesText .= "$num- $home $timeFormatted $away\n";

        // اگر لیگ بعدی تغییر کند خط جداکننده اضافه می‌شود
        $index++; 
    }
        $gamesText .= "ــــــــــــــــــــــــــــــــــــــــــــــ\n\n";


    if ($index === 1) {
        sendMessage($chat_id, "📭 هیچ بازی‌ای برای پیش‌بینی موجود نیست.");
        return;
    }

    $keyboard = [
        [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']]
    ];

    $gamesText = convertEntofanumber($gamesText);

    sendMessage($chat_id, $gamesText, json_encode([
        'inline_keyboard' => $keyboard
    ]));
}

function showTodayLeagues($chat_id) {
    global $db;

    // ⛔️ چک محدودیت پیش‌بینی رایگان
    $warning_message = "🚫 پیش‌بینی‌های رایگان شما تمام شده است (۵ پیش‌بینی انجام داده‌اید).\n\nبرای ادامه باید در هر دو کانال عضو شوید:\n\n🔗 @GoalTiime\n🔗 @KickPrediict";
    
    $stmt = $db->prepare("SELECT total_predictions FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $total_predictions = (int)$stmt->fetchColumn();
    
    if ($total_predictions >= 1 && 
       (!isUserInChannel($chat_id, '@GoalTiime') || !isUserInChannel($chat_id, '@KickPrediict'))) {
        
        sendMessage($chat_id, $warning_message, [
            'inline_keyboard' => [
                [
                    ['text' => '🔗 عضویت در GoalTiime', 'url' => 'https://t.me/GoalTiime'],
                    ['text' => '🔗 عضویت در KickPrediict', 'url' => 'https://t.me/KickPrediict']
                ]
            ]
        ]);
        return;
    }


    $today = date("Y-m-d");
    $stmt = $db->prepare("
        SELECT DISTINCT l.id, l.name
        FROM matches m
        JOIN leagues l ON l.id = m.league_id
        WHERE m.match_day = ? AND m.match_time > NOW()
        ORDER BY l.name ASC
    ");
    $stmt->execute([$today]);
    $leagues = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($leagues)) {
        sendMessage($chat_id, "📭 هیچ لیگی برای پیش‌بینی موجود نیست.");
        return;
    }

    $keyboard = [];
    foreach ($leagues as $row) {
        $leagueId = (int)$row['id'];
        $leagueName = getleagues($row['name']);
        $keyboard[] = [
            ['text' => "🏆 $leagueName", 'callback_data' => "select_league_$leagueId"]
        ];
    }
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']];

    sendMessage(
        $chat_id,
        "📋 <b>لیگ مورد نظرت رو انتخاب کن:</b>\n\n".
        "🎯 این بخش رایگانه! نتیجه بازی‌ها رو پیش‌بینی کن و امتیاز بگیر.",
        ['inline_keyboard' => $keyboard],
        'HTML'
    );
}

function showMatchesByLeague($chat_id, $leagueId) {
    global $db;

    // بازی‌های امروز این لیگ را از دیتابیس می‌گیریم
    $today = date("Y-m-d");

    $stmt = $db->prepare("
        SELECT id, team_home, team_away, match_time
        FROM matches
        WHERE league_id = ? AND match_day = ? 
        ORDER BY match_time ASC
    ");
    $stmt->execute([$leagueId, $today]);
    $matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$matches) {
        sendMessage($chat_id, "📭 برای این لیگ بازی‌ای پیدا نشد.");
        return;
    }

    $gamesText = "📋 <b>یکی از بازی‌های این لیگ رو انتخاب کن و پیش‌بینی کن.</b>\n\n".
    "⚠️ دقت کن! پیش‌بینی درست یعنی توکن بیشتر و بعداً می‌تونی پول جمع کنی یا سرمایه‌گذاری کنی. 💰\n".
    "😅 و لطفاً همه دکمه‌ها رو با هم نزن، چون ربات قهر می‌کنه!";
    $keyboard = [];
    $now = date('Y-m-d H:i:s');
    $index = 1;

    foreach ($matches as $m) {

        // اگر زمان بازی گذشته باشد، رد می‌کنیم
        if ($m['match_time'] <= $now) {
            continue;
        }

        $home = getTeamName($m['team_home']);
        $away = getTeamName($m['team_away']);
        $eid  = $m['id'];

        $keyboard[] = [[
            'text' => "$home 🆚 $away",
            'callback_data' => "start_predict_{$eid}_{$home}_{$away}"
        ]];
        $index++;
    }

    if (count($keyboard) === 0) {
        sendMessage($chat_id, "📭 همه بازی‌های این لیگ شروع شده‌اند و دیگر قابل پیش‌بینی نیستند.");
        return;
    }

    // دکمه بازگشت
    $keyboard[] = [['text' => '🔙 بازگشت به لیگ‌ها', 'callback_data' => 'start_prediction']];

    sendMessage($chat_id, $gamesText, json_encode([
        'inline_keyboard' => $keyboard
    ]));
}

function showPredictionOptionsSimple($chat_id, $home, $away, $matchId) {
    $keyboard = [
        [['text' => "🏆 برد $home", 'callback_data' => "vote_{$matchId}_1"]],
        [['text' => "🤝 مساوی", 'callback_data' => "vote_{$matchId}_X"]],
        [['text' => "🏆 برد $away", 'callback_data' => "vote_{$matchId}_2"]],
        [['text' => '🔙 بازگشت به لیگ‌ها', 'callback_data' => 'start_prediction']]
    ];

    $text = "🔮 <b>نتیجه این بازی رو پیش‌بینی کن و امتیاز بگیر!</b>\n\n".
    "⚽️ <b>$home</b> vs <b>$away</b>\n\n".
    "‼️دقت کن تو انتخابت! قبلش می‌تونی بازی‌ها رو آنالیز کنی، نتایج کانال رو ببینی یا از پیش‌بینی‌های حرفه‌ای‌ها الهام بگیری تا توام جزو بهترین‌ها بشی . ";

    sendMessage($chat_id, $text, [
        'inline_keyboard' => $keyboard
    ]);  // ❌ حذف json_encode
}

function buildTodayMatchesText($My_Ligs = []) {
    $url = "https://prod-public-api.livescore.com/v1/api/app/date/soccer/" . date("Ymd") . "/3.30?countryCode=FR&locale=en&MD=1";
    $response = file_get_contents($url);
    $data = json_decode($response);

    if (!isset($data->Stages)) {
        return null;
    }

    $gamesText = "📅 بازی‌های امروز:\n\n";
    $printedLeagues = [];

    foreach ($data->Stages as $league) {
        if (!isset($league->Events)) continue;

        $events = is_object($league->Events) ? get_object_vars($league->Events) : $league->Events;
        $leagueId = $league->Sid ?? rand(10000, 99999);

        if (!empty($My_Ligs) && !in_array((int)$leagueId, $My_Ligs)) continue;

        $leagueMatches = "";
        foreach ($events as $event) {
            if (!isset($event->T1[0]->Nm) || !isset($event->T2[0]->Nm)) continue;

            $home = $event->T1[0]->Nm;
            $away = $event->T2[0]->Nm;

            $timeFormatted = isset($event->Esd)
                ? substr($event->Esd, -6, 2) . ':' . substr($event->Esd, -4, 2)
                : 'NS';

            $leagueMatches .= "▫️$home $timeFormatted $away\n";
        }

        if (!empty($leagueMatches)) {
            $leagueTitle = $league->CompN ?? ($league->Snm ?? 'League');
            $countryName = $league->Csnm ?? 'Unknown';
            $gamesText .= "⚽️  *$countryName: $leagueTitle*\n";
            $gamesText .= $leagueMatches . "\n";
        }
    }

    return trim($gamesText);
}

function sendPlainMessage($chat_id, $text) {
    global $config;
    $url = "https://api.telegram.org/bot{$config['token']}/sendMessage";

    $post_fields = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    $opts = [
        "http" => [
            "method" => "POST",
            "header" => "Content-Type:application/x-www-form-urlencoded",
            "content" => http_build_query($post_fields)
        ]
    ];

    file_get_contents($url, false, stream_context_create($opts));
}

function logMessage($level, $message) {
    $logLine = "[" . date("Y-m-d H:i:s") . "] [$level] " . $message . PHP_EOL;
    $logLine = mb_convert_encoding($logLine, 'UTF-8', 'UTF-8'); // برای فارسی
    file_put_contents(__DIR__ . "/logs/app.log", $logLine, FILE_APPEND | LOCK_EX);
}

function handleReferral($new_user_id, $referrer_id) {
    global $db;

    // جلوگیری از ثبت خودکاربری یا دعوت تکراری
    if ($new_user_id == $referrer_id) {
        return;
    }

    // بررسی اینکه کاربر جدید قبلاً معرف داشته یا نه
    $stmt = $db->prepare("SELECT invited_by FROM users WHERE user_id = ?");
    $stmt->execute([$new_user_id]);
    $existing = $stmt->fetchColumn();

    if ($existing) {
        // معرف قبلاً ثبت شده، پس هیچ کاری نکن
        return;
    }

    // ثبت معرف در جدول users
    $stmt = $db->prepare("UPDATE users SET invited_by = ? WHERE user_id = ?");
    $stmt->execute([$referrer_id, $new_user_id]);

    // بررسی تعداد دعوت‌های معرف در ۷ روز اخیر
    $stmt = $db->prepare("
        SELECT COUNT(*) 
        FROM invitations 
        WHERE user_id = ? 
          AND created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)
    ");
    $stmt->execute([$referrer_id]);
    $count = $stmt->fetchColumn();

    if ($count >= 10) {
        // سقف دعوت پر شده، فقط ثبت معرف انجام شده
        return;
    }
    
        // بررسی عضویت referrer در کانال‌ها
    $required_channels = ["@GoalTiime", "@KickPrediict"];
    global $config; // برای استفاده از توکن
    foreach ($required_channels as $channel) {
        $check = file_get_contents("https://api.telegram.org/bot".$config['token']."/getChatMember?chat_id={$channel}&user_id={$referrer_id}");
        $data = json_decode($check, true);

        if (!isset($data['ok']) || $data['ok'] == false ||
            in_array($data['result']['status'], ['left','kicked'])) {
            // اگر referrer عضو نیست، پاداش نمی‌گیرد
            return;
        }
    }

    // ثبت دعوت موفق در جدول invitations
    $stmt = $db->prepare("INSERT INTO invitations (user_id, invited_user_id, created_at) VALUES (?, ?, NOW())");
    $stmt->execute([$referrer_id, $new_user_id]);

    // افزودن امتیاز
    rewardReferrer($referrer_id);
}

function rewardReferrer($referrer_id) {
    global $db;

    $stmt = $db->prepare("UPDATE users SET score = score + 35 WHERE user_id = ?");
    $stmt->execute([$referrer_id]);
}

function showPoolIntro($chat_id, $message_id) {
    $message = "🌊 در این استخر فوتبالی، تمام توکن‌های سرمایه‌گذاری‌شده روی هر گزینه به صورت لحظه‌ای نمایش داده میشه! در پایان بازی، اگه گزینه انتخابی تو برنده بشه، به اندازه سهمت از استخر جایزه می‌بری! 🎉\n\n⚠️ توجه: در صورت باخت، توکن‌های سرمایه‌گذاری‌شده از بین میره، پس حتما قوانین رو بخون.\n\n👇 قوانین رو کامل بخون یا مستقیم شروع کن!";

    $buttons = [
        [['text' => '🚀 شروع سرمایه‌گذاری', 'callback_data' => 'start_pool']],
            [['text' => '📜 قوانین سرمایه‌گذاری در استخر', 'callback_data' => 'pool_rules']],
        [
            ['text' => '🔙 بازگشت به منو', 'callback_data' => 'start']
        ]
    ];

    editMessageText($chat_id, $message_id, $message, [
        'inline_keyboard' => $buttons
    ]);
}

function editMessageText($chat_id, $message_id, $text, $keyboard = null, $parse_mode = 'HTML') {
    global $website;

    $url = $website . "editMessageText";

    $post_fields = [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => $parse_mode
    ];

    if ($keyboard) {
        if (is_array($keyboard)) {
            $post_fields['reply_markup'] = json_encode($keyboard);
        } else {
            $post_fields['reply_markup'] = $keyboard;
        }
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        error_log('cURL error (editMessageText): ' . curl_error($ch));
    }
    curl_close($ch);
    return $result;
}

function showPoolRules($chat_id, $message_id) {
$rules = "📜 <b>قوانین و شرایط سرمایه‌گذاری در استخر پیش‌بینی فوتبال</b>\n\n"

. "1️⃣ شما می‌توانید با امتیازهای خود روی یکی از گزینه‌های <b>برد تیم اول، مساوی یا برد تیم دوم</b> سرمایه‌گذاری کنید.\n"
. "2️⃣ میزان امتیازی که وارد می‌کنید، در استخر همان گزینه ذخیره می‌شود.\n"
. "3️⃣ حداقل سرمایه‌گذاری <b>۵۰ توکن</b> و حداکثر <b>۱۵۰۰ توکن</b> برای هر بازی است.\n"
. "4️⃣ برای سرمایه‌گذاری می‌توانید از توکن‌هایی که در پیش‌بینی‌های رایگان جمع کرده‌اید استفاده کنید، یا با خرید توکن، میزان سرمایه‌گذاری خود را افزایش دهید.\n"
. "5️⃣ پس از پایان بازی، کل استخر (بعد از کسر کارمزد) فقط بین کاربرانی که پیش‌بینی صحیح داشته‌اند تقسیم می‌شود، به نسبت مقدار سرمایه‌گذاری.\n"
. "6️⃣ اگر پیش‌بینی شما اشتباه باشد، تمام امتیازهای سرمایه‌گذاری‌شده شما از بین می‌رود و بازگردانده نمی‌شود.\n"
. "7️⃣ در صورتی که نتیجه بازی مساوی باشد و تعداد کاربران و مبلغ سرمایه‌گذاری دو طرف (برد تیم اول و برد تیم دوم) دقیقاً برابر باشد، سیستم به هر برنده ۱۵٪ جایزه اضافه پرداخت خواهد کرد.\n"
. "8️⃣ از کل استخر، مبلغی معادل ۱۰٪ به عنوان کارمزد سیستم کسر می‌شود.\n"
. "   ⚠️ در صورتی که شرایط بند ۷ برقرار باشد (همه چیز مساوی)، این کارمزد کسر نمی‌شود و سیستم به هر برنده ۱۵٪ پاداش اضافه می‌دهد.\n"
. "9️⃣ هرگونه سوءاستفاده، ایجاد حساب‌های متعدد یا اقدام غیرقانونی باعث مسدود شدن حساب و از بین رفتن امتیازها خواهد شد.\n"
. "🔟 سرمایه‌گذاری در استخر همراه با ریسک است و مسئولیت کامل سود یا زیان با شماست.\n"
. "1️⃣1️⃣ تصمیمات نهایی سیستم قطعی است و اعتراضی در این زمینه پذیرفته نخواهد شد.\n\n"

. "⚠️ <b>با پذیرش این قوانین، شما تمامی ریسک‌ها و شرایط سرمایه‌گذاری را قبول می‌کنید.</b>";

$buttons = [
    [['text' => '✅ قوانین رو می‌پذیرم و ادامه میدم', 'callback_data' => 'pool_accept_rules']],
    [['text' => '🔙 بازگشت', 'callback_data' => 'pool_invest']]
];

sendMessage($chat_id, $rules, [
    'inline_keyboard' => $buttons
]);
}

function confirmPoolRules($chat_id) {
    global $db;

    // ثبت تایید قوانین در دیتابیس
    $stmt = $db->prepare("UPDATE users SET pool_rules_accepted = 1 WHERE user_id = ?");
    $stmt->execute([$chat_id]);

    // ادامه ارسال پیام
    $text = "✅ قوانین تأیید شد!\n\nحالا می‌تونی روی یکی از گزینه‌ها سرمایه‌گذاری کنی. آماده‌ای؟";

    $buttons = [
        [['text' => '🚀 شروع سرمایه‌گذاری', 'callback_data' => 'start_pool']],
        [['text' => '🔙 بازگشت به منو', 'callback_data' => 'pool_invest']]
    ];

    sendMessage($chat_id, $text, [
        'inline_keyboard' => $buttons
    ]);
}

function hasAcceptedPoolRules($chat_id) {
    global $db;

    $stmt = $db->prepare("SELECT pool_rules_accepted FROM users WHERE user_id = ?");
    $stmt->execute([$chat_id]);
    $accepted = $stmt->fetchColumn();

    return ($accepted == 1);  // مقدار بولین بازگردانده می‌شود
}

function showPoolLeagues($chat_id) {
    global $db;

    $today = date("Y-m-d");
    $stmt = $db->prepare("
        SELECT DISTINCT l.id, l.name
        FROM matches m
        JOIN leagues l ON l.id = m.league_id
        WHERE m.match_day = ? AND m.match_time > NOW()
        ORDER BY l.name ASC
    ");
    $stmt->execute([$today]);
    $leagues = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($leagues)) {
        sendMessage($chat_id, "📭 هیچ لیگی برای سرمایه‌گذاری موجود نیست.");
        return;
    }

    $keyboard = [];
    foreach ($leagues as $row) {
        $leagueId = (int)$row['id'];
        $leagueName = getleagues($row['name']);
        $keyboard[] = [['text' => "🏆 $leagueName", 'callback_data' => "pool_league_$leagueId"]];
    }
    $keyboard[] = [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']];

    $userscore = showUserScore($chat_id);
    sendMessage(
        $chat_id,
        "💰 <b>انتخاب کن تو کدوم لیگ میخوای سرمایه‌گذاری کنی!</b>\n\n".
        "💎 موجودی فعلی: <b>" . convertEntofanumber($userscore) . " توکن</b>",
        json_encode(['inline_keyboard' => $keyboard]),
        'HTML'
    );
}

function showPoolMatchesByLeague_Pool($chat_id, $leagueId) {
    global $db;

    $today = date("Y-m-d");

    // بازی‌های امروز این لیگ را از دیتابیس می‌گیریم
    $stmt = $db->prepare("
        SELECT id, team_home, team_away, match_time
        FROM matches
        WHERE league_id = ? AND match_day = ?
        ORDER BY match_time ASC
    ");
    $stmt->execute([$leagueId, $today]);
    $matches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$matches) {
        sendMessage($chat_id, "📭 برای این لیگ بازی‌ای پیدا نشد.");
        return;
    }

    $gamesText = 
    "📋 <b>بازی مورد نظر خودت رو برای سرمایه‌گذاری انتخاب و پیش‌بینی کن.</b>\n\n".
    "🎯 با دقت انتخاب کن! هرچه انتخابت درست‌تر باشه، سود بیشتری از استخر می‌گیری.\n".
    "💡 یادت باشه مدیریت ریسک هم بخشی از بازیه!";
    $keyboard = [];
    $now = date('Y-m-d H:i:s');
    $index = 1;

    foreach ($matches as $m) {

        // حذف بازی‌هایی که زمان‌شان گذشته است
        if ($m['match_time'] <= $now) {
            continue;
        }

        $home = getTeamName($m['team_home']);
        $away = getTeamName($m['team_away']);
        $eid  = $m['id'];

        $keyboard[] = [[
            'text' => "$home 🆚 $away",
            'callback_data' => "pool_match_{$eid}"
        ]];
        $index++;
    }

    if (count($keyboard) === 0) {
        sendMessage($chat_id, "📭 همه بازی‌های این لیگ شروع شده‌اند و دیگر قابل سرمایه‌گذاری نیستند.");
        return;
    }

    $keyboard[] = [['text' => '🔙 بازگشت به لیگ‌ها', 'callback_data' => 'start_pool']];

    sendMessage($chat_id, $gamesText, json_encode([
        'inline_keyboard' => $keyboard
    ]));
}

function showPoolPredictionOptions($chat_id, $match_id) {
    global $db;

    $stmt = $db->prepare("SELECT team_home, team_away FROM matches WHERE id = ?");
    $stmt->execute([$match_id]);
    $match = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$match) {
        sendMessage($chat_id, "❌ مشکلی در دریافت اطلاعات بازی پیش آمد.");
        return;
    }

    $home = getTeamName($match['team_home']);
    $away = getTeamName($match['team_away']);

    // تنظیمات استخر
    $min_invest = 50;
    $max_invest = 1500;
    $fee = 10;  // درصد کارمزد

    // وضعیت فعلی استخر
    $tokens = getAllOptionTokens($match_id);
    $homeTokens = $tokens['home'];
    $drawTokens = $tokens['draw'];
    $awayTokens = $tokens['away'];

    // متن توضیح و آمار استخر
    $text = "🎯 <b>سرمایه‌گذاری روی این بازی:</b>\n\n"
          . "🔻 حداقل سرمایه‌گذاری: {$min_invest} توکن\n"
          . "🔺 حداکثر سرمایه‌گذاری: {$max_invest} توکن\n\n"
        //   . "💸 کارمزد استخر: {$fee}٪\n\n"
          . "📊 <b>وضعیت فعلی استخر:</b>\n"
          . "🏆 برد {$home}: <b>{$homeTokens}</b> سرمایه گذاری شده\n"
          . "🤝 مساوی: <b>{$drawTokens}</b> توکن سرمایه گذاری شده\n"
          . "🏆 برد {$away}: <b>{$awayTokens}</b> توکن سرمایه گذاری شده\n\n"
          . "🔽 یکی از گزینه‌های زیر رو برای سرمایه‌گذاری انتخاب کن:";
          
    $text = convertEntofanumber($text);

    // دکمه‌های انتخاب گزینه
    $keyboard = [
        [['text' => "🏆 برد $home", 'callback_data' => "pool_vote_{$match_id}_home"]],
        [['text' => "🤝 مساوی", 'callback_data' => "pool_vote_{$match_id}_draw"]],
        [['text' => "🏆 برد $away", 'callback_data' => "pool_vote_{$match_id}_away"]],
        [['text' => '🔄 بروزرسانی وضعیت فعلی استخر', 'callback_data' => "refresh_pool_{$match_id}"]],
        [['text' => '🔙 بازگشت به بازی‌ها', 'callback_data' => 'start_pool']]
    ];

    sendMessage($chat_id, $text, json_encode([
        'inline_keyboard' => $keyboard
    ]), 'HTML');
}

function getOptionTokens($match_id, $option) {
    global $db;

    $stmt = $db->prepare("SELECT SUM(tokens) FROM pool_investments WHERE match_id = ? AND option_selected = ?");
    $stmt->execute([$match_id, $option]);
    $total = $stmt->fetchColumn();

    return $total ?: 0;
}

function showMyInvestments($chat_id) {
    global $db;

    $stmt = $db->prepare("
        SELECT * 
        FROM pool_investments 
        WHERE user_id = ? 
        ORDER BY created_at DESC 
        LIMIT 5
    ");
    $stmt->execute([$chat_id]);
    $investments = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$investments) {
        sendMessage($chat_id, "ℹ️ شما هیچ سرمایه‌گذاری فعالی ندارید.");
        return;
    }

    $msg = "📋 اینجا میتونی لیست پنج سرمایه گذاری آخرت رو ببینی.\nبرای دیدن تمام لیستت به پروفایل حرفه ایت مراجعه کن.\n\n";
    
    foreach ($investments as $inv) {
        $status = ($inv['is_closed'] == 1) 
            ? ($inv['is_winner'] == 1 ? "🏆 برنده" : "❌ بازنده") 
            : "⏳ در انتظار نتیجه";
    
        // دریافت اطلاعات تیم‌های این بازی
        $stmt = $db->prepare("SELECT team_home, team_away, result FROM matches WHERE id = ?");
        $stmt->execute([$inv['match_id']]);
        $match = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // محاسبه مجموع سرمایه استخر
        $stmt = $db->prepare("SELECT SUM(tokens) FROM pool_investments WHERE match_id = ?");
        $stmt->execute([$inv['match_id']]);
        $pool_total = $stmt->fetchColumn() ?? 0;
    
        $home = getTeamName($match['team_home']);
        $away = getTeamName($match['team_away']);
        $real_result = $match['result'];
    
        $msg .= "🏟️ $home vs $away\n";
        $msg .= "🔸 پیش‌بینی تو: " . matchText($inv['option_selected'], $home, $away) . "\n";
    
        if ($inv['is_closed'] == 1) {
            $msg .= "🔹 نتیجه واقعی: " . matchText($real_result, $home, $away) . "\n";
        }
        
        $msg .= "🎲 مجموعه سرمایه استخر: {$pool_total}\n";
        $msg .= "💰 مقدار سرمایه‌گذاری: {$inv['tokens']} توکن\n";
        $msg .= "🪙  برد شما: {$inv['tokens_won']}\n";
        $msg .= "📊 وضعیت: {$status}\n";
        $msg .= "-----------------------------\n";
    }
    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '🔙 بازگشت', 'callback_data' => 'profile_menu']
            ]
        ]
    ];
    
    sendMessage($chat_id, $msg, $keyboard);

}

function getAllOptionTokens($match_id) {
    global $db;

    $stmt = $db->prepare("
        SELECT option_selected, SUM(tokens) as total
        FROM pool_investments
        WHERE match_id = ?
        GROUP BY option_selected
    ");
    $stmt->execute([$match_id]);

    $results = [
        'home' => 0,
        'draw' => 0,
        'away' => 0
    ];

    foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
        $option = $row['option_selected'];
        $results[$option] = $row['total'];
    }

    return $results;
}

function isUserMember($chat_id) {
    global $config;

    $channels = ['KickPrediict', 'GoalTiime'];
    $token = $config['token'];

    foreach ($channels as $channel) {
        $url = "https://api.telegram.org/bot$token/getChatMember?chat_id=" . urlencode("@$channel") . "&user_id=$chat_id";
        $response = json_decode(file_get_contents($url), true);

        // بررسی خطای API
        if (!$response || $response['ok'] !== true) {
            return false;  // خطا = اجازه نده
        }

        $status = $response['result']['status'] ?? null;

        if (!in_array($status, ['member', 'creator', 'administrator'])) {
            return false;  // عضو نیست
        }
    }

    return true;  // عضو هر دو کاناله
}

function isUserInChannel($chat_id, $channel) {
    global $config;
    $token = $config['token'];

    $url = "https://api.telegram.org/bot$token/getChatMember?chat_id=" . urlencode($channel) . "&user_id=$chat_id";
    $response = json_decode(file_get_contents($url), true);

    if (!$response || $response['ok'] !== true) {
        return false;
    }

    $status = $response['result']['status'] ?? null;

    return in_array($status, ['member', 'creator', 'administrator']);
}

// ذخیره یا آپدیت session کاربر
function setUserSession($user_id, $mode, $data = null) {
    global $db;

    // اگر آرایه باشه، json_encode کن
    if (is_array($data)) {
        $data = json_encode($data, JSON_UNESCAPED_UNICODE);
    }

    $stmt = $db->prepare("
        INSERT INTO user_sessions (user_id, mode, data)
        VALUES (?, ?, ?)
        ON DUPLICATE KEY UPDATE
            mode = VALUES(mode),
            data = VALUES(data),
            updated_at = NOW()
    ");
    $stmt->execute([$user_id, $mode, $data]);
}

// گرفتن session کاربر
function getUserSession($user_id) {
    global $db;
    $stmt = $db->prepare("SELECT mode, data FROM user_sessions WHERE user_id = ?");
    $stmt->execute([$user_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // اگر data مقدار داشته باشد، json_decode شود
        if (!empty($row['data'])) {
            $decoded = json_decode($row['data'], true);
            // اگر decode موفق بود، همان آرایه را جایگزین کن
            if (json_last_error() === JSON_ERROR_NONE) {
                $row['data'] = $decoded;
            }
        }
        return $row;
    }

    return null;
}

// حذف session
function clearUserSession($user_id) {
    global $db;
    $stmt = $db->prepare("DELETE FROM user_sessions WHERE user_id = ?");
    $stmt->execute([$user_id]);
}

function rate_limit_check($user_id, $action, $limit, $windowSec) {
    global $db;

    $now = time();
    $win = $now - ($now % $windowSec);

    $stmt = $db->prepare("SELECT count FROM rate_limits WHERE user_id=? AND action=? AND window_start=?");
    $stmt->execute([$user_id, $action, $win]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        if ((int)$row['count'] >= $limit) {
            return false; // 🚫 محدودیت رد شد
        }
        $upd = $db->prepare("UPDATE rate_limits SET count = count + 1 WHERE user_id=? AND action=? AND window_start=?");
        $upd->execute([$user_id, $action, $win]);
    } else {
        $ins = $db->prepare("INSERT INTO rate_limits (user_id, action, window_start, count) VALUES (?, ?, ?, 1)");
        $ins->execute([$user_id, $action, $win]);
    }

    return true;
}

function showBotRules($chat_id, $message_id) {
$rules = "📜 <b>قوانین و مقررات استفاده از ربات پیش‌بینی فوتبال</b>\n\n"

. "1️⃣ <b>پیش‌بینی رایگان</b> برای همه کاربران آزاد است. در بخش «پیش‌بینی رایگان» می‌توانید بازی‌های روز را انتخاب کرده و بدون پرداخت هزینه پیش‌بینی کنید.\n"
. "2️⃣ امتیازهایی که به دست می‌آورید با نام <b>توکن</b> در حساب شما ذخیره می‌شوند.\n"
. "3️⃣ توکن‌ها ارزش مالی دارند و می‌توانید آنها را:\n"
. "   • به فروش برسانید 💰\n"
. "   • یا در بخش سرمایه‌گذاری استفاده کنید و شانس خود را برای چند برابر کردن امتحان کنید.\n"
. "4️⃣ در صورت سرمایه‌گذاری، از دست رفتن توکن‌ها در نتیجه پیش‌بینی اشتباه کاملاً به عهده خود کاربر است.\n"
. "5️⃣ عضویت در کانال‌های معرفی‌شده الزامی است. در صورتی که بعد از عضویت، کانال‌ها را ترک کنید، امکان فروش توکن برای شما مسدود خواهد شد.\n"
. "6️⃣ فروش توکن تنها برای شماره‌های ثبت‌شده با پیش‌شماره <b>ایران، آلمان و اتریش</b> امکان‌پذیر است. سایر کشورها پشتیبانی نمی‌شوند.\n"
. "7️⃣ اطلاعات کاربری شما باید واقعی باشد (نام، شماره تلفن و کارت بانکی). در صورت عدم تطابق، درخواست‌های مالی تأیید نخواهد شد.\n"
. "8️⃣ هرگونه ایجاد حساب‌های متعدد یا سوءاستفاده از سیستم منجر به مسدودی دائمی حساب و از بین رفتن توکن‌ها خواهد شد.\n"
. "9️⃣ در بخش پروفایل کاربری می‌توانید سوابق، پیش‌بینی‌ها و وضعیت حساب خود را مشاهده کنید.\n"
. "🔟 پشتیبانی همیشه در کنار شماست. در صورت وجود سؤال یا مشکل می‌توانید از طریق بخش پشتیبانی پیام ارسال کنید.\n\n"

. "⚠️ <b>با استفاده از این ربات، شما قوانین فوق را پذیرفته و مسئولیت کامل فعالیت‌های خود را قبول می‌کنید.</b>";

$buttons = [
    [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']]
];

sendMessage($chat_id, $rules, [
    'inline_keyboard' => $buttons
]);
}

function fact_rules($chat_id, $message_id = null) {
    $faq = "❓ <b>پاسخ به سوالات پرتکرار شما</b>\n\n"

    . "❓ <b>ربات پیش‌بینی فوتبال چیکار می‌کنه؟</b>\n"
    . "بازی‌های مهم روز رو میاره تا پیش‌بینی کنی.\n\n"

    . "❓ <b>پیش‌بینی بازی‌های روز در ربات رایگانه؟</b>\n"
    . "بله؛ در «پیش‌بینی رایگان» بدون هزینه.\n\n"

    . "❓ <b>امتیاز چیه و چطوری میتونم امتیاز بگیرم؟</b>\n"
    . "با هر پیش‌بینی درست در بخش رایگان، ۵ امتیاز (توکن) می‌گیری.\n هر بازی که درست پیش‌بینی کنی، به حسابت ۵ امتیاز اضافه می‌شه.\n\n"

    . "❓ <b>توکن/کیوب‌کوین چیه؟</b>\n"
    . "همون امتیازهاست؛ به اسم «کیوب‌کوین» و قابلیت خرید و فروش داره.\n\n"

    . "❓ <b>اگه اشتباه پیش‌بینی کنم امتیاز کم می‌شه؟</b>\n"
    . "نه.\n\n"

    . "❓ <b>امتیازهای رایگان قابل فروشه؟</b>\n"
    . "بله؛ در صورت رعایت قوانین، توکن‌هات توسط سیستم و بعدا بازار فعال، خریده می‌شن.\n\n"

    . "❓ <b>امکان سرمایه‌گذاری با توکن (امتیاز)هام رو دارم؟</b>\n"
    . "بله؛ بعد از رسیدن به حداقل مقدارلازم، که این مقدار حداقل 50 توکن میباشد.\n\n"

    . "❓ <b>تفاوت سرمایه‌گذاری با رایگان؟</b>\n"
    . "رایگان فقط ۵ امتیاز در برد می‌ده؛ سرمایه‌گذاری با توکن انجام می‌دی و در برد، توکن بیشتری می‌گیری.\n\n"

    . "❓ <b>استخر سرمایه‌گذاری چیه؟</b>\n"
    . "سرمایه‌گذاری جمعی روی هر بازیه؛ توکن‌ها تو یه استخر جمع می‌شن و آخر بازی بین برنده‌ها تقسیم می‌شن. در شرایط مساوی ممکنه تا ۱۵٪ هدیه از صندوق بدیم.\n\n"

    . "❓ <b>می‌تونم توکن بخرم؟</b>\n"
    . "بله؛ از «خرید توکن سرمایه‌گذاری» استفاده کن.\n\n"

    . "❓ <b>پروفایل کاربری چیه؟</b>\n"
    . "تمام فعالیت‌هات از روز اول با جزئیات نمایش داده می‌شه.\n\n"

    . "❓ <b>دعوت از دوستان جایزه داره؟</b>\n"
    . "بله؛ به ازای هر دوست جدید، ۱۵ توکن.\n\n"

    . "❓ <b>بدون شماره تماس میتونم امتیازهام (توکن) رو بفروشم؟</b>\n"
    . "نه.\n\n"

    . "❓ <b>شماره‌های مجاز برای فروش؟</b>\n"
    . "فقط پیش‌شماره‌های ایران، آلمان، اتریش.\n\n"

    . "🗳 ما منتظر <b>پیشنهادات و انتقادات</b> شما هستیم.\n"
    . "سؤال دیگری داری؟ با <b>پشتیبانی</b> تماس بگیر.";

    $buttons = [
        [['text' => '🔙 بازگشت', 'callback_data' => 'main_menu']]
    ];

    sendMessage($chat_id, $faq, [
        'inline_keyboard' => $buttons
    ]);
}
