<?php
date_default_timezone_set("Asia/Tehran");
$config = require __DIR__ . '/config.php';

try {
    $db = new PDO(
        "mysql:host={$config['db_host']};dbname={$config['db_name']};charset=utf8mb4",
        $config['db_user'],
        $config['db_pass']
    );
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    file_put_contents("debug_delete_error.txt", "❌ DB Error: " . $e->getMessage() . "\n", FILE_APPEND);
    exit;
}

// فقط حذف بازی‌های دیروز، بعد از ساعت 09:00
$yesterday = date("Y-m-d", strtotime("-1 day"));
$currentTime = date("H:i");

if ($currentTime >= "09:00") {
    $stmt = $db->prepare("DELETE FROM matches WHERE match_day = ?");
    $stmt->execute([$yesterday]);
    file_put_contents("debug_delete_log.txt", "✅ Deleted matches from $yesterday at $currentTime\n", FILE_APPEND);
} else {
    file_put_contents("debug_delete_log.txt", "⏳ Skip delete: now=$currentTime\n", FILE_APPEND);
}
